/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.TypesUtil;
import org.eclipse.papyrusrt.codegen.cpp.rts.UMLRTRuntime;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Constructor;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppNamespace;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Enumerator;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.LinkageSpec;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberField;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberFunction;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.OffsetOf;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.UserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.AbstractFunctionCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.AddressOfExpr;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.BlockInitializer;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ElementAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.IntegralLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.Sizeof;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.StringLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.ReturnStatement;
import org.eclipse.papyrusrt.codegen.utils.RTSModelLibraryUtils;
import org.eclipse.papyrusrt.codegen.utils.XTUMLRTUtil;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;

public class ProtocolGenerator
extends AbstractCppGenerator {
    private final Protocol protocol;
    private final Map<Signal, Variable> payloadVariables = new HashMap<Signal, Variable>();

    public ProtocolGenerator(CppCodePattern cpp, Protocol protocol) {
        super(cpp);
        this.protocol = protocol;
    }

    @Override
    protected CppCodePattern.Output getOutputKind() {
        return CppCodePattern.Output.ProtocolClass;
    }

    @Override
    public String getLabel() {
        return String.valueOf(super.getLabel()) + ' ' + this.protocol.getName();
    }

    @Override
    public boolean generate() {
        ElementList elements = this.cpp.getElementList(CppCodePattern.Output.ProtocolClass, (NamedElement)this.protocol);
        CppNamespace cppProtocol = this.cpp.getWritableCppNamespace(CppCodePattern.Output.ProtocolClass, (NamedElement)this.protocol);
        CppClass baseRole = this.getRole(CppCodePattern.Output.ProtocolBaseRole);
        CppClass conjRole = this.getRole(CppCodePattern.Output.ProtocolConjugateRole);
        for (Signal signal : RTSModelLibraryUtils.getAllUserSignals((Protocol)this.protocol)) {
            Enumerator sigEnumerator = this.cpp.getEnumerator(CppCodePattern.Output.SignalId, (NamedElement)signal, XTUMLRTUtil.getOwner((CommonElement)signal));
            switch (signal.getKind()) {
                case IN: {
                    conjRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunction(elements, cppProtocol, signal, sigEnumerator));
                    break;
                }
                case OUT: {
                    baseRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunction(elements, cppProtocol, signal, sigEnumerator));
                    break;
                }
                case INOUT: {
                    conjRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunction(elements, cppProtocol, signal, sigEnumerator));
                    baseRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunction(elements, cppProtocol, signal, sigEnumerator));
                }
            }
        }
        return true;
    }

    @Override
    public List<FileName> getGeneratedFilenames() {
        ArrayList<FileName> result = new ArrayList<FileName>();
        ElementList el = this.cpp.getElementList(CppCodePattern.Output.ProtocolClass, (NamedElement)this.protocol);
        result.add(el.getName());
        return result;
    }

    protected CppClass getRole(CppCodePattern.Output kind) {
        CppClass cls = this.cpp.getCppClass(kind, (NamedElement)this.protocol);
        cls.addBase(CppClass.Access.PUBLIC, (org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)UMLRTRuntime.UMLRTProtocol.Element);
        Constructor ctor = this.cpp.getConstructor(kind, (NamedElement)this.protocol);
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(UMLRTRuntime.UMLRTCommsPort.getType().ptr().const_().ref(), "srcPort");
        ctor.add(param);
        AbstractFunctionCall baseCtorCall = UMLRTRuntime.UMLRTProtocol.Ctor();
        baseCtorCall.addArgument((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)param));
        ctor.addBaseInitializer(baseCtorCall);
        return cls;
    }

    protected MemberFunction getSignalFunction(ElementList elements, CppNamespace cppProtocol, Signal signal, Enumerator sigEnumerator) {
        MemberFunction f = new MemberFunction(UMLRTRuntime.UMLRTOutSignal.getType(), signal.getName(), Type.CVQualifier.CONST);
        Variable signalVar = new Variable(UMLRTRuntime.UMLRTOutSignal.getType(), "signal");
        f.add(signalVar);
        Variable payload = this.getPayloadDescriptor(elements, cppProtocol, signal);
        AbstractFunctionCall initialize = UMLRTRuntime.UMLRTSignal.initialize((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)signalVar), (Expression)new StringLiteral(signal.getName()), (Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)sigEnumerator), (Expression)UMLRTRuntime.UMLRTProtocol.srcPort(), (Expression)new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)payload)));
        f.add((Expression)initialize);
        for (Parameter param : signal.getParameters()) {
            org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter p = this.createSignalParameter(param);
            f.add(p);
            initialize.addArgument((Expression)new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)p)));
        }
        f.add(new Statement[]{new ReturnStatement((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)signalVar))});
        return f;
    }

    protected org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter createSignalParameter(Parameter param) {
        Type paramType = TypesUtil.createCppType(this.cpp, (NamedElement)param, param.getType());
        if (!(paramType instanceof PrimitiveType) && !paramType.isIndirect()) {
            paramType = paramType.const_().ref();
        }
        return new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(paramType, param.getName());
    }

    protected Variable getPayloadDescriptor(ElementList elements, CppNamespace cppProtocol, Signal signal) {
        Variable payload = this.payloadVariables.get(signal);
        if (payload != null) {
            return payload;
        }
        BlockInitializer fieldsInit = new BlockInitializer(UMLRTRuntime.UMLRTObject.getFieldType().arrayOf(null));
        Variable fields = new Variable(LinkageSpec.STATIC, fieldsInit.getType(), "fields_" + signal.getName(), (Expression)fieldsInit);
        elements.insertElement((IUserElement)fields, (IUserElement)cppProtocol);
        IntegralLiteral sizeofPayload = null;
        if (signal.getParameters().size() == 1) {
            Parameter param = (Parameter)signal.getParameters().get(0);
            fieldsInit.addExpression((Expression)new BlockInitializer(UMLRTRuntime.UMLRTObject.getFieldType(), new Expression[]{new StringLiteral(param.getName()), TypesUtil.createRTTypeAccess(this.cpp, (NamedElement)param, param.getType()), new IntegralLiteral(0), new IntegralLiteral(1), new IntegralLiteral(0)}));
            sizeofPayload = new Sizeof(TypesUtil.createCppType(this.cpp, (NamedElement)param, param.getType()));
        } else if (signal.getParameters().size() > 1) {
            CppClass packingStruct = new CppClass(UserElement.GenerationTarget.DEFN_ONLY, CppClass.Kind.STRUCT, "params_" + signal.getName());
            elements.insertElement((IUserElement)packingStruct, (IUserElement)fields);
            for (Parameter param : signal.getParameters()) {
                String fieldName = param.getName();
                packingStruct.addMember(CppClass.Visibility.PUBLIC, new MemberField(TypesUtil.createCppType(this.cpp, (NamedElement)param, param.getType()), fieldName));
                fieldsInit.addExpression((Expression)new BlockInitializer(UMLRTRuntime.UMLRTObject.getFieldType(), new Expression[]{new StringLiteral(fieldName), TypesUtil.createRTTypeAccess(this.cpp, (NamedElement)param, param.getType()), new OffsetOf(packingStruct, fieldName), new IntegralLiteral(1), new IntegralLiteral(0)}));
                sizeofPayload = new Sizeof((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)packingStruct);
            }
        }
        payload = new Variable(LinkageSpec.STATIC, UMLRTRuntime.UMLRTObject.getObjectType(), "payload_" + signal.getName(), (Expression)new BlockInitializer(UMLRTRuntime.UMLRTObject.getObjectType(), new Expression[]{sizeofPayload == null ? new IntegralLiteral(0) : sizeofPayload, new IntegralLiteral(fields.getNumInitializedInstances()), new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)fields)}));
        elements.insertElement((IUserElement)payload, (IUserElement)cppProtocol);
        this.payloadVariables.put(signal, payload);
        return payload;
    }
}

