/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class BlockInitializer
extends Expression {
    private final Type type;
    protected final ArrayList<Expression> exprs = new ArrayList();

    public BlockInitializer(Type type) {
        this.type = type;
    }

    public BlockInitializer(Type type, Expression ... exprs) {
        this.type = type;
        this.exprs.addAll(Arrays.asList(exprs));
    }

    public void addExpression(Expression expr) {
        this.exprs.add(expr);
    }

    public int getNumInitializers() {
        return this.exprs.size();
    }

    @Override
    protected Type createType() {
        return this.type;
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return Expression.Precedence.Default;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        if (!this.type.isArray() || this.type.dereference().isIndirect() ? !this.type.addDependencies(deps) : !this.type.dereference().addDependencies(deps)) {
            return false;
        }
        for (Expression expr : this.exprs) {
            if (expr.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (!fmt.openBrace()) {
            return false;
        }
        boolean first = true;
        for (Expression init : this.exprs) {
            if (first) {
                first = false;
            } else if (!fmt.writeLn(',')) {
                return false;
            }
            if (init.write(fmt)) continue;
            return false;
        }
        return fmt.closeBrace(false);
    }
}

