/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.codegen.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.codegen.extensionpoints.ILangCodegen2;
import org.eclipse.papyrus.codegen.extensionpoints.MethodInfo;
import org.eclipse.papyrus.codegen.extensionpoints.SyncInformation;
import org.eclipse.papyrusrt.codegen.cpp.statemachines.flat.CppNamesUtil;
import org.eclipse.papyrusrt.codegen.papyrus.UMLRTGenerator;
import org.eclipse.papyrusrt.codegen.papyrus.internal.UMLRTCppCodeGen;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRealTimeStateMach.RTStateMachine;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CppLangCodegen
implements ILangCodegen2 {
    private static EObject context;

    public void generateCode(IProject project, PackageableElement element, IProgressMonitor monitor) {
        context = element;
        ArrayList<EObject> targets = new ArrayList<EObject>();
        targets.add(EcoreUtil.getRootContainer((EObject)element));
        String top = UMLRTCppCodeGen.getTopCapsuleName((Element)EcoreUtil.getRootContainer((EObject)element));
        UMLRTGenerator.INSTANCE.generate(targets, top, true);
    }

    public IProject getTargetProject(PackageableElement pe, boolean createIfMissing) {
        return UMLRTGenerator.INSTANCE.getProject((EObject)pe);
    }

    public String getFileName(IProject project, NamedElement element) {
        Class clazz = null;
        NamedElement container = element;
        while (container != null) {
            if (container instanceof Class) {
                clazz = (Class)container;
                break;
            }
            container = container.eContainer();
        }
        if (clazz == null) {
            return null;
        }
        IFolder srcFolder = project.getFolder("src");
        IFile file = srcFolder.getFile(clazz.getName());
        return file.getProjectRelativePath().toString();
    }

    public void cleanCode(IProject project, PackageableElement element, IProgressMonitor monitor) {
    }

    public String getDescription() {
        return "UMLRT Code generator";
    }

    public SyncInformation getSyncInformation(String methodName, String body) {
        SyncInformation si = new SyncInformation();
        Pattern stringPattern = Pattern.compile("/\\* UMLRT-CODEGEN:(.*)\\*/");
        Matcher m = stringPattern.matcher(body);
        if (m.find()) {
            si.isGenerated = false;
            String uri = m.group(1);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)context);
            EObject eo = domain.getResourceSet().getEObject(URI.createURI((String)uri.trim()), true);
            if (eo instanceof Behavior) {
                si.behavior = (Behavior)eo;
            } else if (eo instanceof Operation) {
                Operation op = (Operation)eo;
                EList methods = op.getMethods();
                if (!methods.isEmpty()) {
                    si.behavior = (Behavior)methods.get(0);
                } else {
                    Behavior ob = this.getParentClass((EObject)op).createOwnedBehavior(op.getName().toLowerCase(), UMLPackage.Literals.OPAQUE_BEHAVIOR);
                    op.getMethods().add((Object)ob);
                    si.behavior = ob;
                }
            }
        } else {
            si.isGenerated = true;
        }
        return si;
    }

    public boolean isEligible(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Element should not be null");
        }
        if (((Package)EcoreUtil.getRootContainer((EObject)element)).getAppliedProfile("UMLRealTime") == null) {
            return false;
        }
        if (element instanceof Class) {
            return true;
        }
        if (element instanceof Transition && this.getParentTransition((EObject)element) != null) {
            return true;
        }
        return element instanceof Operation;
    }

    private Class getParentClass(EObject element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Class) {
            return (Class)element;
        }
        EObject parent = element.eContainer();
        return this.getParentClass(parent);
    }

    private Element getParentTransition(EObject element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)element), RTStateMachine.class) != null) {
            return (Element)element;
        }
        EObject parent = element.eContainer();
        return this.getParentTransition(parent);
    }

    public String getSuffix(ILangCodegen.FILE_KIND fileKind) {
        if (fileKind == ILangCodegen.FILE_KIND.BODY) {
            return "cc";
        }
        if (fileKind == ILangCodegen.FILE_KIND.HEADER) {
            return "hh";
        }
        return "";
    }

    public MethodInfo getMethodInfo(NamedElement operationOrBehavior) {
        BehavioralFeature bf;
        if (operationOrBehavior instanceof OpaqueBehavior && this.getParentTransition((EObject)operationOrBehavior) != null) {
            String name = CppNamesUtil.getFuncName((NamedElement)((Behavior)operationOrBehavior)).toString();
            MethodInfo info = new MethodInfo(name);
            info.addParameterType("const UMLRTMessage*");
            return info;
        }
        Operation op = null;
        if (operationOrBehavior instanceof Operation) {
            op = (Operation)operationOrBehavior;
        }
        if (operationOrBehavior instanceof OpaqueBehavior && (bf = ((OpaqueBehavior)operationOrBehavior).getSpecification()) != null && bf instanceof Operation) {
            op = (Operation)bf;
        }
        if (op != null) {
            MethodInfo info = new MethodInfo(op.getName());
            for (Parameter p : op.getOwnedParameters()) {
                if (p.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                info.addParameterType(p.getType().getName());
            }
            return info;
        }
        return null;
    }
}

