/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.utils;

import com.google.common.base.Objects;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.utils.UMLRealTimeProfileUtil;
import org.eclipse.papyrusrt.codegen.utils.XTUMLRTUtil;
import org.eclipse.papyrusrt.xtumlrt.common.Annotation;
import org.eclipse.papyrusrt.xtumlrt.common.AnnotationParameter;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.Type;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RTSModelLibraryUtils {
    private static ResourceSet resourceSet;
    private static boolean reload;
    private static Model RTSModelLibrary;
    public static final String RTS_MODLIB_PATHMAP = "pathmap://UMLRTRTSLIB/UMLRT-RTS.uml";
    public static final String RTS_MODLIB_ROOT_ID = "_mPjAgGXmEeS_4daqvwyFrg";
    public static final String RTS_LIBRARY_NAME = "UMLRT-RTS";
    public static final URI RTS_LIBRARY_URI;
    public static final String RTS_LIBRARY_URI_STR;
    public static final String FRAME_PROTOCOL_NAME = "Frame";
    public static final String TIMING_PROTOCOL_NAME = "Timing";
    public static final String LOG_PROTOCOL_NAME = "Log";
    public static final String BASECOMM_PROTOCOL_NAME = "UMLRTBaseCommProtocol";
    public static final String TIMEOUT_MESSAGE_NAME = "timeout";
    public static final String RTBOUND_MESSAGE_NAME = "rtBound";
    public static final String RTUNBOUND_MESSAGE_NAME = "rtUnbound";
    public static final String CAPSULE_ID_TYPE_NAME = "UMLRTCapsuleId";
    public static final String TIMER_ID_TYPE_NAME = "UMLRTTimerId";
    public static final String TIME_SPEC_TYPE_NAME = "UMLRTTimespec";
    public static final String TIME_SPEC_2_TYPE_NAME = "UMLRTTimeSpec";
    public static final String INTERNAL_PACKAGE_NAME = "Internal";
    private static Collaboration FRAME_PROTOCOL;
    private static Collaboration TIMING_PROTOCOL;
    private static Collaboration LOG_PROTOCOL;
    private static Collaboration BASECOMM_PROTOCOL;
    private static Object TIMEOUT_MESSAGE;
    private static Object RTBOUND_MESSAGE;
    private static Object RTUNBOUND_MESSAGE;

    static {
        reload = true;
        RTS_LIBRARY_URI = URI.createURI((String)RTS_MODLIB_PATHMAP).appendFragment(RTS_MODLIB_ROOT_ID);
        RTS_LIBRARY_URI_STR = RTS_LIBRARY_URI.toPlatformString(false);
        FRAME_PROTOCOL = null;
        TIMING_PROTOCOL = null;
        LOG_PROTOCOL = null;
        BASECOMM_PROTOCOL = null;
        TIMEOUT_MESSAGE = null;
        RTBOUND_MESSAGE = null;
        RTUNBOUND_MESSAGE = null;
    }

    public static Package loadPackage(URI fullURI) {
        if (resourceSet == null) {
            String _platformString = fullURI.toPlatformString(true);
            String _plus = "Unable to load package " + _platformString;
            String _plus_1 = String.valueOf(_plus) + "; Resource set is null";
            CodeGenPlugin.warning((String)_plus_1);
            return null;
        }
        Resource resource = resourceSet.getResource(fullURI, true);
        if (resource == null) {
            String _platformString_1 = fullURI.toPlatformString(true);
            String _plus_2 = "Unable to load package " + _platformString_1;
            String _plus_3 = String.valueOf(_plus_2) + "; resource is null";
            CodeGenPlugin.warning((String)_plus_3);
            return null;
        }
        EList contents = resource.getContents();
        if (contents == null) {
            String _platformString_2 = fullURI.toPlatformString(true);
            String _plus_4 = "Unable to load package " + _platformString_2;
            String _plus_5 = String.valueOf(_plus_4) + "; contents is null";
            CodeGenPlugin.warning((String)_plus_5);
            return null;
        }
        Object eobj = EcoreUtil.getObjectByType((Collection)contents, (EClassifier)UMLPackage.Literals.PACKAGE);
        if (eobj == null || !(eobj instanceof Package)) {
            String _platformString_3 = fullURI.toPlatformString(true);
            String _plus_6 = "Unable to load package " + _platformString_3;
            String _plus_7 = String.valueOf(_plus_6) + "; first element is null or not a UML Package";
            CodeGenPlugin.warning((String)_plus_7);
            return null;
        }
        Package pkg = (Package)eobj;
        return pkg;
    }

    public static Model loadRTSModelLibrary() {
        String _qualifiedName;
        boolean _notEquals;
        boolean _not;
        Model _xblockexpression = null;
        if (!reload) {
            Object _xifexpression = null;
            if (resourceSet == null) {
                CodeGenPlugin.warning((String)"Unable to load RTS Model Library; Resource set is null");
                return null;
            }
            return _xifexpression;
        }
        URIConverter uriConverter = resourceSet.getURIConverter();
        if (uriConverter == null) {
            CodeGenPlugin.warning((String)"Unable to load RTS Model Library; Resource set's URI converter is null");
            return null;
        }
        URI normalizedRTSLibURI = uriConverter.normalize(RTS_LIBRARY_URI);
        Package pkg = RTSModelLibraryUtils.loadPackage(normalizedRTSLibURI);
        if (pkg == null || !(pkg instanceof Model)) {
            CodeGenPlugin.warning((String)"Unable to load RTS Model Library; contained UML Package is not a UML Model");
            return null;
        }
        boolean _isModelLibrary = pkg.isModelLibrary();
        boolean bl = _not = !_isModelLibrary;
        if (_not) {
            CodeGenPlugin.warning((String)"Loaded model is not a model library");
        }
        boolean bl2 = _notEquals = !Objects.equal((Object)(_qualifiedName = pkg.getQualifiedName()), (Object)RTS_LIBRARY_NAME);
        if (_notEquals) {
            CodeGenPlugin.warning((String)"Loaded model library's name is not RTS");
        }
        _xblockexpression = RTSModelLibrary = (Model)pkg;
        return _xblockexpression;
    }

    public static Model reloadRTSModelLibrary() {
        Model _xblockexpression = null;
        reload = true;
        _xblockexpression = RTSModelLibraryUtils.loadRTSModelLibrary();
        return _xblockexpression;
    }

    public static boolean setReload(boolean flag) {
        reload = flag;
        return reload;
    }

    public static boolean setResourceSet(ResourceSet resSet) {
        boolean _xifexpression = false;
        if (resSet != resourceSet || resourceSet == null) {
            boolean _xblockexpression = false;
            resourceSet = resSet;
            reload = true;
            _xifexpression = _xblockexpression = true;
        } else {
            reload = false;
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public static Model getRTSModelLibrary() {
        return RTSModelLibrary;
    }

    public static Collaboration getProtocol(Package packge, String name) {
        Collaboration _xblockexpression = null;
        PackageableElement protocolContainer = packge.getPackagedElement(name);
        Collaboration _xifexpression = null;
        boolean _and = false;
        _and = protocolContainer == null ? false : protocolContainer instanceof Package;
        if (_and) {
            Collaboration _xblockexpression_1 = null;
            PackageableElement protocol = ((Package)protocolContainer).getPackagedElement(name);
            Collaboration _xifexpression_1 = null;
            boolean _and_1 = false;
            _and_1 = protocol == null ? false : protocol instanceof Collaboration;
            if (_and_1) {
                _xifexpression_1 = (Collaboration)protocol;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Collaboration getFrameProtocol() {
        Collaboration _xblockexpression = null;
        boolean _or = false;
        _or = FRAME_PROTOCOL == null ? true : reload;
        if (_or) {
            Collaboration _protocol;
            FRAME_PROTOCOL = _protocol = RTSModelLibraryUtils.getProtocol((Package)RTSModelLibrary, FRAME_PROTOCOL_NAME);
        }
        _xblockexpression = FRAME_PROTOCOL;
        return _xblockexpression;
    }

    public static Collaboration getTimingProtocol() {
        Collaboration _xblockexpression = null;
        boolean _or = false;
        _or = TIMING_PROTOCOL == null ? true : reload;
        if (_or) {
            Collaboration _protocol;
            TIMING_PROTOCOL = _protocol = RTSModelLibraryUtils.getProtocol((Package)RTSModelLibrary, TIMING_PROTOCOL_NAME);
        }
        _xblockexpression = TIMING_PROTOCOL;
        return _xblockexpression;
    }

    public static Collaboration getLogProtocol() {
        Collaboration _xblockexpression = null;
        boolean _or = false;
        _or = LOG_PROTOCOL == null ? true : reload;
        if (_or) {
            Collaboration _protocol;
            LOG_PROTOCOL = _protocol = RTSModelLibraryUtils.getProtocol((Package)RTSModelLibrary, LOG_PROTOCOL_NAME);
        }
        _xblockexpression = LOG_PROTOCOL;
        return _xblockexpression;
    }

    public static Collaboration getBaseCommProtocol() {
        PackageableElement internalPackage;
        Collaboration _xblockexpression = null;
        boolean _or = false;
        _or = BASECOMM_PROTOCOL == null ? true : reload;
        if (_or && (internalPackage = RTSModelLibrary.getPackagedElement(INTERNAL_PACKAGE_NAME)) instanceof Package) {
            Collaboration _protocol;
            BASECOMM_PROTOCOL = _protocol = RTSModelLibraryUtils.getProtocol((Package)internalPackage, BASECOMM_PROTOCOL_NAME);
        }
        _xblockexpression = BASECOMM_PROTOCOL;
        return _xblockexpression;
    }

    public static Object getTimeout() {
        Object _xblockexpression = null;
        boolean _or = false;
        _or = TIMEOUT_MESSAGE == null ? true : reload;
        if (_or) {
            Collaboration _timingProtocol = RTSModelLibraryUtils.getTimingProtocol();
            Iterable<Operation> _inProtocolMessages = UMLRealTimeProfileUtil.getInProtocolMessages(_timingProtocol, false);
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)RTSModelLibraryUtils.TIMEOUT_MESSAGE_NAME);
                }
            };
            Operation _findFirst = (Operation)IterableExtensions.findFirst(_inProtocolMessages, (Functions.Function1)_function);
            TIMEOUT_MESSAGE = _findFirst;
        }
        _xblockexpression = TIMEOUT_MESSAGE;
        return _xblockexpression;
    }

    public static Object getRtBound() {
        Object _xblockexpression = null;
        boolean _or = false;
        _or = RTBOUND_MESSAGE == null ? true : reload;
        if (_or) {
            Collaboration _baseCommProtocol = RTSModelLibraryUtils.getBaseCommProtocol();
            Iterable<Operation> _inOutProtocolMessages = UMLRealTimeProfileUtil.getInOutProtocolMessages(_baseCommProtocol);
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)RTSModelLibraryUtils.RTBOUND_MESSAGE_NAME);
                }
            };
            Operation _findFirst = (Operation)IterableExtensions.findFirst(_inOutProtocolMessages, (Functions.Function1)_function);
            RTBOUND_MESSAGE = _findFirst;
        }
        _xblockexpression = RTBOUND_MESSAGE;
        return _xblockexpression;
    }

    public static Object getRtUnbound() {
        Object _xblockexpression = null;
        boolean _or = false;
        _or = RTUNBOUND_MESSAGE == null ? true : reload;
        if (_or) {
            Collaboration _baseCommProtocol = RTSModelLibraryUtils.getBaseCommProtocol();
            Iterable<Operation> _inOutProtocolMessages = UMLRealTimeProfileUtil.getInOutProtocolMessages(_baseCommProtocol);
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)RTSModelLibraryUtils.RTUNBOUND_MESSAGE_NAME);
                }
            };
            Operation _findFirst = (Operation)IterableExtensions.findFirst(_inOutProtocolMessages, (Functions.Function1)_function);
            RTUNBOUND_MESSAGE = _findFirst;
        }
        _xblockexpression = RTUNBOUND_MESSAGE;
        return _xblockexpression;
    }

    public static boolean isRTSModelLibrary(Package packge) {
        boolean _equals_2;
        boolean _xblockexpression = false;
        boolean _equals = Objects.equal((Object)packge, (Object)RTSModelLibrary);
        if (_equals) {
            return true;
        }
        Resource _eResource = packge.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        URIConverter uriConverter = _resourceSet.getURIConverter();
        URI packageURI = EcoreUtil.getURI((EObject)packge);
        URI normalizedPackageURI = uriConverter.normalize(packageURI);
        URI normalizedRTSLibURI = uriConverter.normalize(RTS_LIBRARY_URI);
        boolean _and = false;
        boolean _and_1 = false;
        if (!(packge instanceof Model)) {
            _and_1 = false;
        } else {
            boolean _equals_1;
            String _qualifiedName = packge.getQualifiedName();
            _and_1 = _equals_1 = _qualifiedName.equals(RTS_LIBRARY_NAME);
        }
        _and = !_and_1 ? false : (_equals_2 = Objects.equal((Object)normalizedPackageURI, (Object)normalizedRTSLibURI));
        _xblockexpression = _and;
        return _xblockexpression;
    }

    public static boolean isRTSModelLibrary(org.eclipse.papyrusrt.xtumlrt.common.Model model) {
        boolean _isSystemElement;
        boolean _and = false;
        boolean _and_1 = false;
        if (model == null) {
            _and_1 = false;
        } else {
            boolean _equals;
            String _name = model.getName();
            _and_1 = _equals = Objects.equal((Object)_name, (Object)RTS_LIBRARY_NAME);
        }
        _and = !_and_1 ? false : (_isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)model));
        return _and;
    }

    public static boolean isSystemElement(CommonElement element) {
        EList _annotations;
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        _and_1 = element == null || !(element instanceof NamedElement) ? false : (_tripleNotEquals = (_annotations = ((NamedElement)element).getAnnotations()) != null);
        if (!_and_1) {
            _and = false;
        } else {
            boolean _exists;
            EList _annotations_1 = ((NamedElement)element).getAnnotations();
            Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    EList _parameters_1;
                    boolean _isEmpty;
                    boolean _not;
                    EList _parameters;
                    boolean _tripleNotEquals;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _and_2 = false;
                    String _name = it.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)RTSModelLibraryUtils.RTS_LIBRARY_NAME);
                    _and_2 = !_equals ? false : (_tripleNotEquals = (_parameters = it.getParameters()) != null);
                    _and_1 = !_and_2 ? false : (_not = !(_isEmpty = (_parameters_1 = it.getParameters()).isEmpty()));
                    if (!_and_1) {
                        _and = false;
                    } else {
                        boolean _exists;
                        EList _parameters_2 = it.getParameters();
                        Functions.Function1<AnnotationParameter, Boolean> _function = new Functions.Function1<AnnotationParameter, Boolean>(){

                            public Boolean apply(AnnotationParameter it) {
                                String _value = it.getValue();
                                return Objects.equal((Object)_value, (Object)RTS_LIBRARY_URI_STR);
                            }
                        };
                        _and = _exists = IterableExtensions.exists((Iterable)_parameters_2, (Functions.Function1)_function);
                    }
                    return _and;
                }
            };
            _and = _exists = IterableExtensions.exists((Iterable)_annotations_1, (Functions.Function1)_function);
        }
        return _and;
    }

    public static boolean isSystemElement(Element element) {
        boolean _tripleNotEquals;
        boolean _and = false;
        Model _model = element.getModel();
        boolean bl = _tripleNotEquals = _model != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _isRTSModelLibrary;
            Model _model_1 = element.getModel();
            _and = _isRTSModelLibrary = RTSModelLibraryUtils.isRTSModelLibrary((Package)_model_1);
        }
        return _and;
    }

    public static boolean isCapsuleId(Type type) {
        boolean _isSystemElement;
        String _name;
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = type == null ? false : (_tripleNotEquals = (_name = type.getName()) != null);
        if (!_and_2) {
            _and_1 = false;
        } else {
            boolean _equals;
            String _name_1 = type.getName();
            _and_1 = _equals = Objects.equal((Object)_name_1, (Object)CAPSULE_ID_TYPE_NAME);
        }
        _and = !_and_1 ? false : (_isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)type));
        return _and;
    }

    public static boolean isTimerId(Type type) {
        boolean _isSystemElement;
        String _name;
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = type == null ? false : (_tripleNotEquals = (_name = type.getName()) != null);
        if (!_and_2) {
            _and_1 = false;
        } else {
            boolean _equals;
            String _name_1 = type.getName();
            _and_1 = _equals = Objects.equal((Object)_name_1, (Object)TIMER_ID_TYPE_NAME);
        }
        _and = !_and_1 ? false : (_isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)type));
        return _and;
    }

    public static boolean isTimerSpec(Type type) {
        boolean _isSystemElement;
        String _name;
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = type == null ? false : (_tripleNotEquals = (_name = type.getName()) != null);
        if (!_and_2) {
            _and_1 = false;
        } else {
            boolean _or = false;
            String _name_1 = type.getName();
            boolean _equals = Objects.equal((Object)_name_1, (Object)TIME_SPEC_2_TYPE_NAME);
            if (_equals) {
                _or = true;
            } else {
                boolean _equals_1;
                String _name_2 = type.getName();
                _or = _equals_1 = Objects.equal((Object)_name_2, (Object)TIME_SPEC_TYPE_NAME);
            }
            _and_1 = _or;
        }
        _and = !_and_1 ? false : (_isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)type));
        return _and;
    }

    public static boolean isBaseCommProtocol(Protocol protocol) {
        boolean _isSystemElement;
        String _name;
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = protocol == null ? false : (_tripleNotEquals = (_name = protocol.getName()) != null);
        if (!_and_2) {
            _and_1 = false;
        } else {
            boolean _equals;
            String _name_1 = protocol.getName();
            _and_1 = _equals = Objects.equal((Object)_name_1, (Object)BASECOMM_PROTOCOL_NAME);
        }
        _and = !_and_1 ? false : (_isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)protocol));
        return _and;
    }

    public static boolean isFrameProtocol(Protocol protocol) {
        boolean _isSystemElement;
        String _name;
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = protocol == null ? false : (_tripleNotEquals = (_name = protocol.getName()) != null);
        if (!_and_2) {
            _and_1 = false;
        } else {
            boolean _equals;
            String _name_1 = protocol.getName();
            _and_1 = _equals = Objects.equal((Object)_name_1, (Object)FRAME_PROTOCOL_NAME);
        }
        _and = !_and_1 ? false : (_isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)protocol));
        return _and;
    }

    public static boolean isTimingProtocol(Protocol protocol) {
        boolean _isSystemElement;
        String _name;
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = protocol == null ? false : (_tripleNotEquals = (_name = protocol.getName()) != null);
        if (!_and_2) {
            _and_1 = false;
        } else {
            boolean _equals;
            String _name_1 = protocol.getName();
            _and_1 = _equals = Objects.equal((Object)_name_1, (Object)TIMING_PROTOCOL_NAME);
        }
        _and = !_and_1 ? false : (_isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)protocol));
        return _and;
    }

    public static boolean isLogProtocol(Protocol protocol) {
        boolean _isSystemElement;
        String _name;
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        _and_2 = protocol == null ? false : (_tripleNotEquals = (_name = protocol.getName()) != null);
        if (!_and_2) {
            _and_1 = false;
        } else {
            boolean _equals;
            String _name_1 = protocol.getName();
            _and_1 = _equals = Objects.equal((Object)_name_1, (Object)LOG_PROTOCOL_NAME);
        }
        _and = !_and_1 ? false : (_isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)protocol));
        return _and;
    }

    public static Iterable<Signal> getAllUserSignals(Protocol protocol) {
        Iterable<Signal> _allSignals = XTUMLRTUtil.getAllSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                boolean _isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)it);
                return !_isSystemElement;
            }
        };
        return IterableExtensions.filter(_allSignals, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getUserSignals(Protocol protocol) {
        Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                boolean _isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)it);
                return !_isSystemElement;
            }
        };
        return IterableExtensions.filter(_signals, (Functions.Function1)_function);
    }
}

