/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.UMLPackage;

/**
 * Generic class for RTPseudoState edit helper advices
 */
public abstract class AbstractRTPseudoStateEditHelperAdvice extends AbstractEditHelperAdvice {

	protected abstract PseudostateKind getKind();

	@Override
	protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
		// sets the pseudo state to initial
		ICommand command = new ConfigureElementCommand(request) {

			/**
			 * {@inheritDoc}
			 */
			@Override
			protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
				EObject elementToConfigure = request.getElementToConfigure();
				if (!(elementToConfigure instanceof Pseudostate)) {
					return CommandResult.newErrorCommandResult("Element to configure is not a pseudostate");
				}
				Pseudostate pseudoState = (Pseudostate) elementToConfigure;
				try {
					SetRequest setKindRequest = new SetRequest(pseudoState, UMLPackage.eINSTANCE.getPseudostate_Kind(), getKind());
					IElementEditService provider = ElementEditServiceUtils.getCommandProvider(pseudoState);
					if (provider == null) {
						throw new ExecutionException("Impossible to get the provider from " + pseudoState);
					}

					ICommand setKindCommand = provider.getEditCommand(setKindRequest);
					if (setKindCommand != null) {
						if (setKindCommand.canExecute()) {
							IStatus status = setKindCommand.execute(monitor, info);
							if (status.isOK()) {
								return CommandResult.newOKCommandResult(pseudoState);
							} else {
								throw new ExecutionException(status.getMessage());
							}
						} else {
							throw new ExecutionException("Command to set the pseudo state kind is not executable");
						}
					} else {
						throw new ExecutionException("Impossible to find a command to set the kind of the pseudo state");
					}
				} catch (ExecutionException e) {
					return CommandResult.newErrorCommandResult(e);
				}
			}

		};

		ICommand superCommand = super.getBeforeConfigureCommand(request);
		if (superCommand != null) {
			// draw the diagram, with initial state displayed
			return command.compose(superCommand).reduce();
		}
		return command.reduce();

	}
}
