/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.IUMLRTElementTypes;
import org.eclipse.uml2.uml.StateMachine;

/**
 * State machine utils
 */
public class StateMachineUtils {

	/** View name for the RT state machine diagram */
	public static final String UMLRT_STATE_MACHINE_DIAGRAM = "UML-RT State Machine Diagram";

	public static boolean isRTStateMachine(StateMachine stateMachine) {
		return ElementTypeUtils.matches(stateMachine, IUMLRTElementTypes.RT_STATE_MACHINE_ID);
	}

}
