/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AbstractRTPseudoStateEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected abstract PseudostateKind getKind();

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        ConfigureElementCommand command = new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
                EObject elementToConfigure = request.getElementToConfigure();
                if (!(elementToConfigure instanceof Pseudostate)) {
                    return CommandResult.newErrorCommandResult((String)"Element to configure is not a pseudostate");
                }
                Pseudostate pseudoState = (Pseudostate)elementToConfigure;
                try {
                    SetRequest setKindRequest = new SetRequest((EObject)pseudoState, (EStructuralFeature)UMLPackage.eINSTANCE.getPseudostate_Kind(), (Object)AbstractRTPseudoStateEditHelperAdvice.this.getKind());
                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)pseudoState);
                    if (provider == null) {
                        throw new ExecutionException("Impossible to get the provider from " + pseudoState);
                    }
                    ICommand setKindCommand = provider.getEditCommand((IEditCommandRequest)setKindRequest);
                    if (setKindCommand != null) {
                        if (setKindCommand.canExecute()) {
                            IStatus status = setKindCommand.execute(monitor, info);
                            if (status.isOK()) {
                                return CommandResult.newOKCommandResult((Object)pseudoState);
                            }
                            throw new ExecutionException(status.getMessage());
                        }
                        throw new ExecutionException("Command to set the pseudo state kind is not executable");
                    }
                    throw new ExecutionException("Impossible to find a command to set the kind of the pseudo state");
                }
                catch (ExecutionException e) {
                    return CommandResult.newErrorCommandResult((Throwable)e);
                }
            }
        };
        ICommand superCommand = super.getBeforeConfigureCommand(request);
        if (superCommand != null) {
            return command.compose((IUndoableOperation)superCommand).reduce();
        }
        return command.reduce();
    }
}

