/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageUtils;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class MessageSetEditHelperAdvice
extends AbstractEditHelperAdvice {
    private static final String CALL_EVENT_COMMAND_LABEL = "Call Event Update";
    private static final String OWNED_OPERATION = "OwnedOperation";

    protected ICommand getBeforeDestroyElementCommand(DestroyElementRequest request) {
        Operation destroyOperation;
        CallEvent relatedCallEvent;
        ICommand command = null;
        if (request.getElementToDestroy() instanceof Operation && (relatedCallEvent = this.getRelatedCallEvent((destroyOperation = (Operation)request.getElementToDestroy()).getNearestPackage(), destroyOperation)) != null) {
            command = this.getDeletionCallEventCommand(relatedCallEvent);
        }
        if (command == null) {
            command = super.getBeforeDestroyElementCommand(request);
        }
        return command;
    }

    protected ICommand getAfterMoveCommand(MoveRequest request) {
        Object result = null;
        CompositeCommand compositeMoveCommand = new CompositeCommand("Composite Move Command");
        Map elementsToMove = request.getElementsToMove();
        if (!elementsToMove.isEmpty()) {
            for (Object elementToMove : elementsToMove.keySet()) {
                Operation operation;
                CallEvent callEvent;
                if (!(elementToMove instanceof Operation) || (callEvent = MessageUtils.getCallEvent(operation = (Operation)elementToMove)) == null) continue;
                MoveElementsCommand command = MessageUtils.createMoveCallEventCommand(request, callEvent);
                compositeMoveCommand.add((IUndoableOperation)command);
            }
        }
        result = compositeMoveCommand.isEmpty() ? super.getAfterMoveCommand(request) : compositeMoveCommand;
        return result;
    }

    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage");
            if (umlRTMessageType == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.approveRequest(request);
            }
            List<IElementType> types = Arrays.asList(type.getAllSuperTypes());
            if (!types.contains(umlRTMessageType)) {
                return false;
            }
            return super.approveRequest(request);
        }
        return super.approveRequest(request);
    }

    protected ICommand getAfterCreateCommand(CreateElementRequest request) {
        return super.getAfterCreateCommand(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        ICommand command = null;
        if (UMLPackage.eINSTANCE.getInterface_OwnedOperation().equals(request.getFeature())) {
            command = this.getCreateCallEventCommand(request);
            if (command == null) {
                command = super.getAfterSetCommand(request);
            }
        } else {
            command = super.getAfterSetCommand(request);
        }
        return command;
    }

    protected ICommand getCreateCallEventCommand(SetRequest request) {
        CompositeCommand callEventCommands = new CompositeCommand(CALL_EVENT_COMMAND_LABEL);
        if (request.getValue() instanceof LinkedList) {
            LinkedList newOperationList = (LinkedList)request.getValue();
            if (request.getElementToEdit() instanceof Interface) {
                ICommand createCommand = this.createNewCallEvent(request, newOperationList);
                callEventCommands.compose((IUndoableOperation)createCommand);
            }
        }
        return callEventCommands.isEmpty() ? null : callEventCommands;
    }

    private ICommand createNewCallEvent(SetRequest request, LinkedList<?> newOperationList) {
        ICommand singleCallEvent = null;
        for (Object operation : newOperationList) {
            if (!(operation instanceof Operation) || !(request.getElementToEdit() instanceof Classifier)) continue;
            singleCallEvent = this.getCallEventCommand((Classifier)request.getElementToEdit(), (Operation)operation);
        }
        return singleCallEvent;
    }

    private ICommand deleteMissingCallEvent(LinkedList<?> newOperationList, Interface messageSet, EList<Operation> oldOperationList) {
        ICommand singleCallEventDeletion = null;
        for (Operation operation : oldOperationList) {
            CallEvent relatedCallEvent = this.getRelatedCallEvent(messageSet.eContainer(), operation);
            if (newOperationList.contains(operation)) continue;
            singleCallEventDeletion = this.getDeletionCallEventCommand(relatedCallEvent);
        }
        return singleCallEventDeletion;
    }

    private ICommand getDeletionCallEventCommand(CallEvent callEvent) {
        ICommand command = null;
        try {
            TransactionalEditingDomain domain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)callEvent);
            DeleteCommand EMFcommand = new DeleteCommand((EditingDomain)domain, Collections.singletonList(callEvent));
            command = EMFtoGMFCommandWrapper.wrap((Command)EMFcommand);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return command;
    }

    protected EList<Operation> getOldMessageList(Interface messageSet) {
        EList messageList = messageSet.getOwnedOperations();
        return messageList;
    }

    protected ICommand getCallEventCommand(Classifier targetClassifier, Operation operation) {
        ICommand command = null;
        if (!this.callEventExist(targetClassifier.eContainer(), operation)) {
            try {
                ICommand createCommand;
                TransactionalEditingDomain domain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)targetClassifier);
                CreateElementRequest createElementRequest = new CreateElementRequest(domain, targetClassifier.eContainer(), UMLElementTypes.CallEvent_2084);
                createElementRequest.setParameter(OWNED_OPERATION, (Object)operation);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetClassifier);
                if (provider != null && (createCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest)) != null) {
                    command = createCommand;
                }
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return command;
    }

    protected boolean callEventExist(Object container, Operation operation) {
        return this.getRelatedCallEvent(container, operation) != null;
    }

    protected CallEvent getRelatedCallEvent(Object container, Operation operation) {
        CallEvent callEvent = null;
        if (container instanceof Package) {
            EList containment = ((Package)container).getOwnedElements();
            Iterator elements = containment.iterator();
            while (callEvent == null && elements.hasNext()) {
                Element element = (Element)elements.next();
                if (!(element instanceof CallEvent) || operation == null || !operation.equals(((CallEvent)element).getOperation())) continue;
                callEvent = (CallEvent)element;
            }
        }
        return callEvent;
    }
}

