/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProtocolContainerConfigurationCommand
extends ConfigureElementCommand {
    private final String name;
    private final Collaboration protocol;
    private IProgressMonitor progressMonitor;
    private IAdaptable info;

    public ProtocolContainerConfigurationCommand(ConfigureRequest request, String name, Collaboration protocol) {
        super(request);
        this.name = name;
        this.protocol = protocol;
    }

    private void createUsage(Collaboration protocol, String name, Interface rtMessageSet) throws ExecutionException {
        Usage usageOut = (Usage)this.createElement(protocol, name, (IElementType)UMLElementTypes.USAGE, Relation.SIBLING);
        usageOut.getClients().add((Object)protocol);
        usageOut.getSuppliers().add((Object)rtMessageSet);
    }

    private void createInterfaceRealization(Collaboration protocol, String name, Interface rtMessageSetInt) throws ExecutionException {
        InterfaceRealization realization = (InterfaceRealization)this.createElement(protocol, name, (IElementType)UMLElementTypes.INTERFACE_REALIZATION, Relation.CHILD);
        realization.setContract(rtMessageSetInt);
        realization.setImplementingClassifier((BehavioredClassifier)protocol);
    }

    protected EObject createElement(Collaboration referenceElement, String name, IElementType elementType, Relation relation) throws ExecutionException {
        if (referenceElement == null) {
            throw new ExecutionException("Either the referenceElement or the name parameter is null. ");
        }
        EObject newElement = null;
        CreateElementRequest createElementRequest = new CreateElementRequest((EObject)referenceElement.getNearestPackage(), elementType);
        createElementRequest.setParameter("nameToSet", (Object)name);
        CreateElementCommand command = new CreateElementCommand(createElementRequest);
        command.execute(this.progressMonitor, this.info);
        newElement = command.getNewElement();
        if (newElement == null) {
            throw new ExecutionException("Element creation problem for " + elementType.getDisplayName() + ".");
        }
        ((NamedElement)newElement).setName(name);
        if (relation == Relation.CHILD) {
            if (elementType == UMLElementTypes.INTERFACE_REALIZATION) {
                referenceElement.getInterfaceRealizations().add((Object)((InterfaceRealization)newElement));
            } else {
                referenceElement.createOwnedAttribute(name, (Type)newElement);
            }
        } else if (relation == Relation.SIBLING) {
            Package nearestPackage = referenceElement.getNearestPackage();
            nearestPackage.getPackagedElements().add((Object)((PackageableElement)newElement));
        } else if (relation == Relation.PARENT) {
            Package container = (Package)newElement;
            EList packagedElements = container.getPackagedElements();
            packagedElements.add((Object)referenceElement);
        }
        return newElement;
    }

    private void setRtMsgKind(Interface rtMessageSetInt, RTMessageKind kind) {
        RTMessageSet rtMessageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)rtMessageSetInt, RTMessageSet.class);
        rtMessageSet.setRtMsgKind(kind);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.progressMonitor = progressMonitor;
        this.info = info;
        this.createElement(this.protocol, this.name, (IElementType)UMLRTElementTypesEnumerator.PROTOCOL_CONTAINER, Relation.PARENT);
        String nameIn = MessageSetUtils.computeInterfaceInName(this.name);
        Interface rtMessageSetInt = (Interface)this.createElement(this.protocol, nameIn, (IElementType)UMLRTElementTypesEnumerator.RT_MESSAGE_SET, Relation.SIBLING);
        this.setRtMsgKind(rtMessageSetInt, RTMessageKind.IN);
        this.createInterfaceRealization(this.protocol, null, rtMessageSetInt);
        String nameOut = MessageSetUtils.computeInterfaceOutName(this.name);
        Interface rtMessageSetOutInt = (Interface)this.createElement(this.protocol, nameOut, (IElementType)UMLRTElementTypesEnumerator.RT_MESSAGE_SET, Relation.SIBLING);
        this.setRtMsgKind(rtMessageSetOutInt, RTMessageKind.OUT);
        this.createUsage(this.protocol, null, rtMessageSetOutInt);
        this.createElement(this.protocol, "*", (IElementType)UMLElementTypes.ANY_RECEIVE_EVENT, Relation.SIBLING);
        String nameInOut = MessageSetUtils.computeInterfaceInOutName(this.name);
        Interface rtMessageSetInOutInt = (Interface)this.createElement(this.protocol, nameInOut, (IElementType)UMLRTElementTypesEnumerator.RT_MESSAGE_SET, Relation.SIBLING);
        this.setRtMsgKind(rtMessageSetInOutInt, RTMessageKind.IN_OUT);
        this.createInterfaceRealization(this.protocol, null, rtMessageSetInOutInt);
        this.createUsage(this.protocol, null, rtMessageSetInOutInt);
        this.protocol.setName(this.name);
        return CommandResult.newOKCommandResult((Object)this.protocol);
    }

    private static enum Relation {
        CHILD,
        SIBLING,
        PARENT;

    }
}

