/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RTPortUtils {
    public static final String RTPORT_KIND_REQUEST_PARAMETER = "RTPORT_KIND";

    public static boolean isRTPort(EObject eObject) {
        if (eObject instanceof Port) {
            Port port = (Port)eObject;
            return RTPortUtils.getStereotypeApplication(port) != null;
        }
        return false;
    }

    public static boolean isConnected(Port port) {
        return port != null && !port.getEnds().isEmpty();
    }

    public static boolean isConnectedInside(Port port) {
        if (!RTPortUtils.isConnected(port)) {
            return false;
        }
        for (ConnectorEnd connectorEnd : port.getEnds()) {
            Element connectorContainer;
            Element connectorEndContainer = connectorEnd.getOwner();
            if (!(connectorEndContainer instanceof Connector) || (connectorContainer = ((Connector)connectorEndContainer).getOwner()) == null || !connectorContainer.equals(port.getClass_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isConnectedOutside(Port port) {
        if (!RTPortUtils.isConnected(port)) {
            return false;
        }
        for (ConnectorEnd connectorEnd : port.getEnds()) {
            Element connectorContainer;
            Element connectorEndContainer = connectorEnd.getOwner();
            if (!(connectorEndContainer instanceof Connector) || (connectorContainer = ((Connector)connectorEndContainer).getOwner()) == null || connectorContainer.equals(port.getClass_())) continue;
            return true;
        }
        return false;
    }

    public static RTPort getStereotypeApplication(Port port) {
        return (RTPort)UMLUtil.getStereotypeApplication((Element)port, RTPort.class);
    }

    public static boolean isWired(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? false : Boolean.valueOf(RTPortUtils.getStereotypeApplication(port).isWired());
    }

    public static boolean isPublish(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? false : Boolean.valueOf(RTPortUtils.getStereotypeApplication(port).isPublish());
    }

    public static boolean isNotification(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? false : Boolean.valueOf(RTPortUtils.getStereotypeApplication(port).isNotification());
    }

    public static boolean isBehavior(Port port) {
        return port.isBehavior();
    }

    public static boolean isService(Port port) {
        return port.isService();
    }

    public static boolean isConjugated(Port port) {
        return port.isConjugated();
    }

    public static RTPortKindEnum getKind(Port port) {
        RTPortKindEnum kind = null;
        if (RTPortUtils.isRTPort((EObject)port)) {
            if (RTPortUtils.isService(port) && RTPortUtils.isWired(port) && RTPortUtils.isBehavior(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.EXTERNAL;
            } else if (RTPortUtils.isBehavior(port) && RTPortUtils.isPublish(port) && !RTPortUtils.isWired(port)) {
                kind = RTPortKindEnum.SPP;
            } else if (RTPortUtils.isWired(port) && RTPortUtils.isBehavior(port) && !RTPortUtils.isService(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.INTERNAL;
            } else if (RTPortUtils.isService(port) && RTPortUtils.isWired(port) && !RTPortUtils.isBehavior(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.RELAY;
            } else if (RTPortUtils.isBehavior(port) && !RTPortUtils.isWired(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.SAP;
            }
        }
        return kind;
    }

    public static Command getChangeKindCommand(Port port, RTPortKindEnum newKind, boolean checkInitialStatus) {
        if (!checkInitialStatus) {
            return RTPortUtils.getChangeKindCommand(port, newKind);
        }
        switch (RTPortUtils.getKind(port)) {
            case EXTERNAL: {
                if (!(RTPortUtils.isConnectedOutside(port) ? RTPortKindEnum.RELAY != newKind && RTPortKindEnum.EXTERNAL != newKind : RTPortUtils.isConnected(port) && (RTPortKindEnum.SAP == newKind || RTPortKindEnum.SPP == newKind))) break;
                return UnexecutableCommand.INSTANCE;
            }
            case INTERNAL: {
                if (RTPortUtils.isConnectedInside(port) && RTPortKindEnum.RELAY != newKind && RTPortKindEnum.INTERNAL != newKind) {
                    return UnexecutableCommand.INSTANCE;
                }
                if (!RTPortUtils.isConnected(port) || RTPortKindEnum.SAP != newKind && RTPortKindEnum.SPP != newKind) break;
                return UnexecutableCommand.INSTANCE;
            }
            case RELAY: {
                if (RTPortUtils.isConnectedInside(port) && RTPortKindEnum.RELAY != newKind && RTPortKindEnum.INTERNAL != newKind) {
                    return UnexecutableCommand.INSTANCE;
                }
                if (RTPortUtils.isConnectedOutside(port) && RTPortKindEnum.RELAY != newKind && RTPortKindEnum.EXTERNAL != newKind) {
                    return UnexecutableCommand.INSTANCE;
                }
                if (!RTPortUtils.isConnected(port) || RTPortKindEnum.SAP != newKind && RTPortKindEnum.SPP != newKind) break;
                return UnexecutableCommand.INSTANCE;
            }
            case SAP: {
                break;
            }
            case SPP: {
                break;
            }
        }
        return RTPortUtils.getChangeKindCommand(port, newKind);
    }

    public static Command getChangeKindCommand(Port port, RTPortKindEnum newKind) {
        Command command = null;
        switch (newKind) {
            case EXTERNAL: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, true, true, true);
                break;
            }
            case INTERNAL: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, false, true, true);
                break;
            }
            case RELAY: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, true, true, false);
                break;
            }
            case SAP: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, false, false, true);
                break;
            }
            case SPP: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, true, false, true);
                break;
            }
            default: {
                command = RTPortUtils.getRTPortKindChangeCommand(port, true, true, false);
            }
        }
        return command;
    }

    protected static Command getRTPortKindChangeCommand(Port port, boolean service, boolean wired, boolean behavior) {
        RTPort rtPort = RTPortUtils.getStereotypeApplication(port);
        if (rtPort == null) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeCommand command = new CompositeCommand("Setting RTPort Kind");
        command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)port, (EStructuralFeature)UMLPackage.eINSTANCE.getPort_IsBehavior(), (Object)behavior)));
        command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)port, (EStructuralFeature)UMLPackage.eINSTANCE.getPort_IsService(), (Object)service)));
        command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)rtPort, (EStructuralFeature)UMLRealTimePackage.eINSTANCE.getRTPort_IsWired(), (Object)wired)));
        command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)rtPort, (EStructuralFeature)UMLRealTimePackage.eINSTANCE.getRTPort_IsPublish(), (Object)(!wired && service ? 1 : 0))));
        return GMFtoEMFCommandWrapper.wrap((ICommand)command);
    }

    public static boolean isLegacySpp(Port port) {
        if (RTPortKindEnum.SPP.equals(RTPortUtils.getKind(port))) {
            return !port.isService();
        }
        return false;
    }

    public static boolean isLegacySap(Port port) {
        if (RTPortKindEnum.SAP.equals(RTPortUtils.getKind(port))) {
            return port.isService();
        }
        return false;
    }
}

