/*****************************************************************************
 * Copyright (c) 2015 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Celine JANSSENS (ALL4TEC) celine.janssens@all4tec.net - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editpolicies;

import java.util.Map;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.SideAffixedNodesCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;
import org.eclipse.uml2.uml.Port;

/**
 * This EditPolicy is installed on the RTClassCompositeEditPart to manage the location of RTPort that could be internal instead of on the border
 * 
 * @author Céline JANSSENS
 *
 */
public class RTSideAffixedNodesCreationEditPolicy extends SideAffixedNodesCreationEditPolicy {

	/**
	 * RTPort UML Element.
	 */
	private Object element = null;

	/**
	 * Set the Uml object and get the Super SetBoundsCommand
	 * 
	 * @see org.eclipse.papyrus.uml.diagram.common.editpolicies.SideAffixedNodesCreationEditPolicy#getSetBoundsCommand(org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest, org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor)
	 *
	 * 
	 */
	@Override
	protected ICommand getSetBoundsCommand(CreateViewRequest request, ViewDescriptor descriptor) {


		if (descriptor.getElementAdapter() instanceof EObjectAdapter) {
			element = ((EObjectAdapter) descriptor.getElementAdapter()).getRealObject();
		}

		return super.getSetBoundsCommand(request, descriptor);




	}

	/**
	 * @param absoluteLocation
	 * @return
	 */
	protected Point getRelativeLocation(Point absoluteLocation) {
		getHostFigure().translateToRelative(absoluteLocation);
		return absoluteLocation.getCopy();
	}

	/**
	 * @param request
	 * @return
	 */
	protected Point getParamLocation(CreateViewRequest request) {
		Map<?, ?> params = request.getExtendedData();
		Point realLocation = (Point) params.get(AspectUnspecifiedTypeCreationTool.INITIAL_MOUSE_LOCATION_FOR_CREATION);
		return realLocation;
	}

	/**
	 * In case the element is an RTPort, set the locator accordingly.
	 * 
	 * @see org.eclipse.papyrus.uml.diagram.common.editpolicies.SideAffixedNodesCreationEditPolicy#getPositionLocator()
	 */
	@Override
	protected PortPositionLocator getPositionLocator() {
		PortPositionLocator locator = null;
		if (element instanceof Port && RTPortUtils.isRTPort((Port) element)) {
			locator = new RTPortPositionLocator((Port) element, getHostFigure(), PositionConstants.NONE);
		}

		return null != locator ? locator : super.getPositionLocator();
	}

	/**
	 * @return
	 */
	protected IFigure getHostFigure() {
		return ((GraphicalEditPart) getHost()).getFigure();
	}

}
