/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PackageEditPart;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.StateMachine;

/**
 * Utility method for diagrams
 */
public class UMLRTStateMachineDiagramUtils {

	private static final String SEPARATOR = "::";

	/**
	 * Returns <code>true</code> if the diagram is a state machine diagram
	 * 
	 * @param diagram
	 *            the diagram to check
	 * @return <code>true</code> if the diagram is a state machine diagram
	 */
	public static boolean isRTStateMachineDiagram(Diagram diagram) {
		if (diagram == null) {
			return false;
		}
		if (PackageEditPart.MODEL_ID.equals(diagram.getType())) {
			// check if it corresponds to the capsule diagram prototype => assume for now that this is a capsule diagram if it is a composite associated to a capsule
			EObject businessElement = diagram.getElement();
			if (businessElement instanceof StateMachine && StateMachineUtils.isRTStateMachine((StateMachine) businessElement)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Returns the name to be displayed for a capsule diagram, e.g. the name of the associated capsule
	 * 
	 * @param diagram
	 *            the diagram to display
	 * @return the name of the associated capsule or the name of the diagram if no capsule can be found
	 */
	public static String getDisplayedDiagramName(Diagram diagram) {
		EObject businessElement = diagram.getElement();

		// check if the diagram has a setted name
		if (diagram.getName() != null && !"".equals(diagram.getName())) {
			return diagram.getName();
		}

		if (businessElement instanceof StateMachine && StateMachineUtils.isRTStateMachine((StateMachine) businessElement)) {
			// check parent capsule of the state machine and get his name
			StringBuffer buffer = new StringBuffer();
			Classifier capsule = ((StateMachine) businessElement).getContext();
			if (capsule != null && capsule.getName() != null) {
				buffer.append(capsule.getName());
				buffer.append(SEPARATOR);
			}
			if (((StateMachine) businessElement).getName() != null) {
				buffer.append(((StateMachine) businessElement).getName());
			}

			if (buffer.length() > 0) {
				return buffer.toString();
			}

			return "<error>";
		}
		return diagram.getName();
	}

}
