/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.decorator;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ScaledImageFigure;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.RTPropertyPartEditPart;
import org.eclipse.swt.graphics.Image;

public class CapsulePartDecorator
extends AbstractDecorator {
    private static final String PLUGIN_ID = "org.eclipse.papyrusrt.umlrt.tooling.ui";
    private static final String DECORATION_PATH = "icons/capsule.png";
    private static final int DECORATION_SIZE_PX = 16;
    private static final IDecoratorTarget.Direction DECORATION_POSITION = IDecoratorTarget.Direction.NORTH_EAST;
    private static final int DECORATION_OFFSET = 3;

    public CapsulePartDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
    }

    public void activate() {
        this.refresh();
    }

    public void refresh() {
        this.removeDecoration();
        EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
        if (editPart instanceof RTPropertyPartEditPart) {
            IFigure editPartFigure = ((GraphicalEditPart)editPart).getFigure();
            Figure figure = new Figure();
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHorizontal(true);
            flowLayout.setMinorSpacing(0);
            figure.setLayoutManager((LayoutManager)flowLayout);
            ScaledImageFigure capsuleIcon = this.getImageNode(DECORATION_PATH);
            figure.add((IFigure)capsuleIcon);
            IMapMode mm = MapModeUtil.getMapMode((IFigure)editPartFigure);
            figure.setSize(mm.DPtoLP(16 * figure.getChildren().size()) + 2, mm.DPtoLP(16));
            this.setDecoration(this.getDecoratorTarget().addShapeDecoration((IFigure)figure, DECORATION_POSITION, -3, false));
            this.getDecoration().setToolTip((IFigure)new Label("GMF Decorations"));
        }
    }

    private ScaledImageFigure getImageNode(String imageLocation) {
        ScaledImageFigure imageFigure = new ScaledImageFigure();
        ImageDescriptor imageDescriptor = Activator.getDefault().getImageDescriptor(PLUGIN_ID, imageLocation);
        if (imageDescriptor != null) {
            Image image = imageDescriptor.createImage();
            imageFigure.setImage(image);
            imageFigure.setSize(16, 16);
        }
        return imageFigure;
    }
}

