/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.utils;

/**
 * Names of facets used in the UML/RT customization
 */
public class FacetUtils {

	static final String IN = "in";  //$NON-NLS-1$
	static final String INOUT = "inout";  //$NON-NLS-1$
	static final String OUT = "out"; //$NON-NLS-1$
	static final String COMMENTS = "comments";  //$NON-NLS-1$

	/**
	 * Check whether the passed facetName is a one of the message set facets (in, out, or inout)
	 * or comment
     *
	 * @param facetName
	 * @return true, if one of the facet names above
	 */
	public static boolean isMessageOrComment(String facetName) {
		return FacetUtils.IN.equals(facetName) || FacetUtils.OUT.equals(facetName) ||
				FacetUtils.INOUT.equals(facetName) || FacetUtils.COMMENTS.equals(facetName);
	}
}
