/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.providers.DelegatingItemLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;

public class UMLRTLabelProvider
extends UMLFilteredLabelProvider {
    public final Map<String, String> typeIdtoIconPath = new HashMap<String, String>();
    protected static String ICON_PATH = "/icons/";
    protected static final String RT_PSEUDO_STATE_CHOICE_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_choice.gif";
    protected static final String RT_PSEUDO_STATE_DEEP_HISTORY_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_deephistory.gif";
    protected static final String RT_PSEUDO_STATE_ENTRY_POINT_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_entrypoint.gif";
    protected static final String RT_PSEUDO_STATE_EXIT_POINT_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_exitpoint.gif";
    protected static final String RT_PSEUDO_STATE_FORK_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_fork.gif";
    protected static final String RT_PSEUDO_STATE_INITIAL_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_initial.gif";
    protected static final String RT_PSEUDO_STATE_JOIN_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_join.gif";
    protected static final String RT_PSEUDO_STATE_JUNCTION_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_junction.gif";
    protected static final String RT_PSEUDO_STATE_SHALLOW_HISTORY_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_shallowhistory.gif";
    protected static final String RT_PSEUDO_STATE_TERMINATE_ICON = String.valueOf(ICON_PATH) + "rt_pseudostate_terminate.gif";
    protected static String RT_MESSAGE_IN_ICON = String.valueOf(ICON_PATH) + "protocolmessage_in.gif";
    protected static String RT_MESSAGE_IN_OUT_ICON = String.valueOf(ICON_PATH) + "protocolmessage_inout.gif";
    protected static String RT_MESSAGE_OUT_ICON = String.valueOf(ICON_PATH) + "protocolmessage_out.gif";
    protected static String RT_MESSAGE_UNDEFINED_ICON = String.valueOf(ICON_PATH) + "protocolmessage_undefined.gif";
    protected static final IItemLabelProvider labelProvider = new DelegatingItemLabelProvider();

    public UMLRTLabelProvider() {
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.Capsule", String.valueOf(ICON_PATH) + "capsule.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.CapsulePart", String.valueOf(ICON_PATH) + "capsule_part.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolContainer", String.valueOf(ICON_PATH) + "protocol_container.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.Protocol", String.valueOf(ICON_PATH) + "protocol.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTConnector", String.valueOf(ICON_PATH) + "rt_connector.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTRExcludedElement", String.valueOf(ICON_PATH) + "rt_excludedElement.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTMessageSet", String.valueOf(ICON_PATH) + "rt_messageset.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPort", String.valueOf(ICON_PATH) + "rt_port.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessageIn", RT_MESSAGE_IN_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessageInOut", RT_MESSAGE_IN_OUT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessageOut", RT_MESSAGE_OUT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage", RT_MESSAGE_UNDEFINED_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTStateMachine", String.valueOf(ICON_PATH) + "rt_statemachine.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTRegion", String.valueOf(ICON_PATH) + "rt_region.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTState", String.valueOf(ICON_PATH) + "rt_state.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState", String.valueOf(ICON_PATH) + "rt_pseudostate.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Choice", RT_PSEUDO_STATE_CHOICE_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_DeepHistory", RT_PSEUDO_STATE_DEEP_HISTORY_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_EntryPoint", RT_PSEUDO_STATE_ENTRY_POINT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_ExitPoint", RT_PSEUDO_STATE_EXIT_POINT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Fork", RT_PSEUDO_STATE_FORK_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Initial", RT_PSEUDO_STATE_INITIAL_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Join", RT_PSEUDO_STATE_JOIN_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Junction", RT_PSEUDO_STATE_JUNCTION_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_ShallowHistory", RT_PSEUDO_STATE_SHALLOW_HISTORY_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Terminate", RT_PSEUDO_STATE_TERMINATE_ICON);
    }

    public Image getImage(Object element) {
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (!(semanticObject instanceof Element)) {
            Activator.log.debug("Trying to display an UMLRT image for a non UML-RT element");
            return null;
        }
        String matchingTypeMatcher = this.getMatchingType(semanticObject);
        Image image = null;
        switch (matchingTypeMatcher) {
            case "org.eclipse.papyrusrt.umlrt.core.ProtocolMessageIn": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_MESSAGE_IN_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.ProtocolMessageOut": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_MESSAGE_OUT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.ProtocolMessageInOut": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_MESSAGE_IN_OUT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Choice": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_CHOICE_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_DeepHistory": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_DEEP_HISTORY_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_EntryPoint": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_ENTRY_POINT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_ExitPoint": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_EXIT_POINT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Fork": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_FORK_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Initial": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_INITIAL_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Join": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_JOIN_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Junction": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_JUNCTION_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_ShallowHistory": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_SHALLOW_HISTORY_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTPseudoState_Terminate": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_PSEUDO_STATE_TERMINATE_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTMessageSet": {
                RTMessageKind kind = MessageSetUtils.getMessageKind((Object)semanticObject);
                if (kind == RTMessageKind.IN) {
                    image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", String.valueOf(ICON_PATH) + "rt_messageset_in.gif");
                    break;
                }
                if (kind == RTMessageKind.OUT) {
                    image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", String.valueOf(ICON_PATH) + "rt_messageset_out.gif");
                    break;
                }
                if (kind == RTMessageKind.IN_OUT) {
                    image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", String.valueOf(ICON_PATH) + "rt_messageset_inout.gif");
                    break;
                }
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", this.typeIdtoIconPath.get("org.eclipse.papyrusrt.umlrt.core.RTMessageSet"));
                break;
            }
            default: {
                image = this.getElementImage(matchingTypeMatcher, semanticObject);
            }
        }
        return image;
    }

    public String getText(Object element) {
        return labelProvider.getText(element);
    }

    protected String getMatchingType(EObject semanticObject) {
        for (IElementType type : UMLRTElementTypesEnumerator.getAllRTTypes()) {
            if (!(type instanceof ISpecializationType) || !((ISpecializationType)type).getMatcher().matches(semanticObject)) continue;
            return type.getId();
        }
        return null;
    }

    protected Image getElementImage(String id, EObject semanticObject) {
        String iconPath = this.typeIdtoIconPath.get(id);
        if (iconPath != null) {
            return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", iconPath);
        }
        return null;
    }
}

