/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.Collections;
import java.util.Set;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.creation.CreationContext;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Messages;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.UMLFactory;

/**
 * ValueFactory for the MessageSet ownedOperation (protocol message for message sets)
 */
public class MessageSetOwnedProtocolMessageValueFactory extends UMLPropertyEditorFactory {

	public static final String SINGLE_PROTOCOL_MESSAGE = "Single ProtocolMessage"; //$NON-NLS-1$

	public static final String UML_RT = "uml-rt"; //$NON-NLS-1$

	public MessageSetOwnedProtocolMessageValueFactory(EReference eReference) {
		super(eReference);
	}

	@Override
	protected EObject simpleCreateObject(Control widget) {
		return UMLFactory.eINSTANCE.createOperation();
	}

	@Override
	public Object edit(Control widget, Object source) {
		Set<View> views = getProtocolMessageViews();
		if (!views.isEmpty()) {
			return doEdit(widget, source, views, getEditionDialogTitle(source));
		}

		return source;
	}

	@Override
	protected Object createObject(Control widget, Object context, Object source) {
		if (source == null) {
			return null;
		}

		Set<View> views = getProtocolMessageViews();
		if (!views.isEmpty()) {
			CreationContext creationContext = getCreationContext(context);
			creationContext.pushCreatedElement(source);
			try {
				return doEdit(widget, source, views, getCreationDialogTitle());
			} finally {
				creationContext.popCreatedElement(source);
			}
		}

		return source;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getCreationDialogTitle() {
		return Messages.MessageSetOwnedProtocolMessageValueFactory_CreateDialogTitle;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getEditionDialogTitle(Object objectToEdit) {
		return Messages.MessageSetOwnedProtocolMessageValueFactory_EditDialogTitle;
	}

	protected Set<View> getProtocolMessageViews() {
		String contextName = UML_RT;
		String viewName = SINGLE_PROTOCOL_MESSAGE;
		Context context = ConfigurationManager.getInstance().getContext(contextName);
		for (View view : context.getViews()) {
			if (viewName.equals(view.getName())) {
				return Collections.singleton(view);
			}
		}
		return Collections.emptySet();
	}
}
