/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.emf.common.command.Command;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.papyrus.views.properties.widgets.AbstractPropertyEditor;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.RTStereotypeModelElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Port;

/**
 * Specific EnumRadio that can have read only status only on some of the radio buttons
 */
public class PortRTKindPropertyEditor extends AbstractPropertyEditor {

	protected PortRTKindValueEditor kindValueEditor;

	protected int numColumns = -1;

	/**
	 * Constructor.
	 *
	 * @param parent
	 *            The composite in which the widget will be displayed
	 * @param style
	 *            The style for the widget
	 */
	public PortRTKindPropertyEditor(Composite parent, int style) {
		super(new PortRTKindValueEditor(parent, style));
		kindValueEditor = (PortRTKindValueEditor) valueEditor;
	}

	/**
	 * Applies the readOnly state to the editor
	 *
	 * @param readOnly
	 *            Indicates if this widget should be read-only
	 */
	protected void applyReadOnly(boolean readOnly) {
		super.applyReadOnly(readOnly);
		if (!readOnly) {
			// should be writable, but check for specific non executable commands
			ModelElement element = input.getModelElement(propertyPath);
			if (element instanceof RTStereotypeModelElement && ((RTStereotypeModelElement) element).getSource() instanceof RTPort) {
				for( RTPortKindEnum enumValue : RTPortKindEnum.values()) {
					Port port = ((RTPort) ((RTStereotypeModelElement) element).getSource()).getBase_Port();
					Command command = RTPortUtils.getChangeKindCommand(port, enumValue, true);
					boolean isEditable = command.canExecute();
					kindValueEditor.setReadOnly(enumValue, isEditable);
				}
			}
		}
	}

	/**
	 * Sets the maximum number of columns for this editor. The radio values
	 * will be distributed according to this number
	 *
	 * @param numColumns
	 */
	public void setNumColumns(int numColumns) {
		this.numColumns = numColumns;
		kindValueEditor.setNumColumns(numColumns);
	}

	/**
	 * Return the maximum number of columns for this editor
	 *
	 * @return
	 * 		The number of columns for this editor
	 */
	public int getNumColumns() {
		return numColumns;
	}

	@Override
	protected void doBinding() {
		kindValueEditor.setProviders(input.getContentProvider(propertyPath), input.getLabelProvider(propertyPath));
		super.doBinding();
	}

}
