/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartKindEnum;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CapsulePartKindObservableValue
extends PapyrusObservableValue
implements IObserving {
    private static final String LABEL_MULTIPLICITY = "Set Multiplicity";
    private static final String LABEL_AGGREGATION = "Set Aggregation";
    private Property capsulePartElement;
    private AggregationKind aggregation;
    private MultiplicityElement multiplicity;

    public CapsulePartKindObservableValue(EObject RTApplication, TransactionalEditingDomain domain) {
        super((EObject)UMLUtil.getBaseElement((EObject)RTApplication), UMLUtil.getBaseElement((EObject)RTApplication).eContainingFeature(), (EditingDomain)domain);
        if (RTApplication instanceof CapsulePart) {
            this.capsulePartElement = (Property)UMLUtil.getBaseElement((EObject)RTApplication);
            this.capsulePartElement.eAdapters().add((Object)this.getListener());
            this.capsulePartElement.getUpperValue().eAdapters().add((Object)this.getListener());
            this.capsulePartElement.getLowerValue().eAdapters().add((Object)this.getListener());
            this.setUMLPropertiesValue();
        }
    }

    protected void setUMLPropertiesValue() {
        if (this.capsulePartElement instanceof Property) {
            this.multiplicity = this.capsulePartElement;
            this.aggregation = this.capsulePartElement.getAggregation();
        }
    }

    protected Object doGetValue() {
        CapsulePartKindEnum kind = null;
        this.setUMLPropertiesValue();
        if (this.multiplicity.getLower() == this.multiplicity.getUpper()) {
            kind = CapsulePartKindEnum.FIXED;
        } else if (this.multiplicity.getLower() == 0) {
            if (AggregationKind.COMPOSITE_LITERAL.equals((Object)this.aggregation)) {
                kind = CapsulePartKindEnum.OPTIONAL;
            } else if (AggregationKind.SHARED_LITERAL.equals((Object)this.aggregation)) {
                kind = CapsulePartKindEnum.PLUGIN;
            }
        }
        return kind;
    }

    public Object getObserved() {
        return this.capsulePartElement;
    }

    public Object getValueType() {
        return CapsulePartKindEnum.class;
    }

    public Command getCommand(Object value) {
        Command command = null;
        if (value instanceof CapsulePartKindEnum) {
            switch ((CapsulePartKindEnum)value) {
                case FIXED: {
                    command = this.getCommandForCapsulePart(AggregationKind.COMPOSITE_LITERAL, this.multiplicity.getUpper(), this.multiplicity.getUpper());
                    break;
                }
                case OPTIONAL: {
                    command = this.getCommandForCapsulePart(AggregationKind.COMPOSITE_LITERAL, 0, this.multiplicity.getUpper());
                    break;
                }
                case PLUGIN: {
                    command = this.getCommandForCapsulePart(AggregationKind.SHARED_LITERAL, 0, this.multiplicity.getUpper());
                    break;
                }
                default: {
                    command = this.getCommandForCapsulePart(AggregationKind.COMPOSITE_LITERAL, this.multiplicity.getUpper(), this.multiplicity.getUpper());
                }
            }
        }
        return command;
    }

    protected Command getCommandForCapsulePart(AggregationKind aggregation, int lower, int upper) {
        CompoundCommand command = new CompoundCommand();
        command.append(this.getSetAggregationCommand(aggregation));
        command.append(this.getSetMultiplicityCommand(lower, upper));
        return command;
    }

    protected Command getSetMultiplicityCommand(final int lower, final int upper) {
        RecordingCommand multiplicityCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                CapsulePartKindObservableValue.this.capsulePartElement.setLower(lower);
                CapsulePartKindObservableValue.this.capsulePartElement.setUpper(upper);
            }

            public boolean canExecute() {
                return true;
            }

            public String getLabel() {
                return CapsulePartKindObservableValue.LABEL_MULTIPLICITY;
            }
        };
        return multiplicityCommand;
    }

    protected AdapterImpl getListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object notifier = notification.getNotifier();
                int type = notification.getEventType();
                Object feature = notification.getFeature();
                if (notifier == CapsulePartKindObservableValue.this.capsulePartElement && type == 1) {
                    if (UMLPackage.eINSTANCE.getProperty_Aggregation().equals(feature)) {
                        this.fireDiff(notification);
                    }
                } else if (notifier == CapsulePartKindObservableValue.this.capsulePartElement.getLowerValue() && type == 1) {
                    this.fireDiff(notification);
                } else if (notifier == CapsulePartKindObservableValue.this.capsulePartElement.getUpperValue() && type == 1) {
                    this.fireDiff(notification);
                }
            }

            private void fireDiff(Notification notification) {
                final ValueDiff diff = Diffs.createValueDiff((Object)notification.getOldValue(), (Object)notification.getNewValue());
                CapsulePartKindObservableValue.this.getRealm().exec(new Runnable(){

                    @Override
                    public void run() {
                        CapsulePartKindObservableValue.this.fireValueChange(diff);
                    }
                });
            }
        };
    }

    protected Command getSetAggregationCommand(final AggregationKind wishedAggregation) {
        RecordingCommand aggregationCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                CapsulePartKindObservableValue.this.capsulePartElement.setAggregation(wishedAggregation);
            }

            public boolean canExecute() {
                return true;
            }

            public String getLabel() {
                return CapsulePartKindObservableValue.LABEL_AGGREGATION;
            }
        };
        return aggregationCommand;
    }
}

