/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.emf.common.command.Command;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.papyrus.views.properties.widgets.AbstractPropertyEditor;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.RTStereotypeModelElement;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PortRTKindValueEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Port;

public class PortRTKindPropertyEditor
extends AbstractPropertyEditor {
    protected PortRTKindValueEditor kindValueEditor = (PortRTKindValueEditor)this.valueEditor;
    protected int numColumns = -1;

    public PortRTKindPropertyEditor(Composite parent, int style) {
        super((AbstractValueEditor)new PortRTKindValueEditor(parent, style));
    }

    protected void applyReadOnly(boolean readOnly) {
        ModelElement element;
        super.applyReadOnly(readOnly);
        if (!readOnly && (element = this.input.getModelElement(this.propertyPath)) instanceof RTStereotypeModelElement && ((RTStereotypeModelElement)element).getSource() instanceof RTPort) {
            RTPortKindEnum[] rTPortKindEnumArray = RTPortKindEnum.values();
            int n = rTPortKindEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                RTPortKindEnum enumValue = rTPortKindEnumArray[n2];
                Port port = ((RTPort)((RTStereotypeModelElement)element).getSource()).getBase_Port();
                Command command = RTPortUtils.getChangeKindCommand((Port)port, (RTPortKindEnum)enumValue, (boolean)true);
                boolean isEditable = command.canExecute();
                this.kindValueEditor.setReadOnly(enumValue, isEditable);
                ++n2;
            }
        }
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
        this.kindValueEditor.setNumColumns(numColumns);
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    protected void doBinding() {
        this.kindValueEditor.setProviders(this.input.getContentProvider(this.propertyPath), this.input.getLabelProvider(this.propertyPath));
        super.doBinding();
    }
}

