/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal;

import java.util.Collections;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.util.InternalUpdateHelper;

public class TransactionalUpdateHelper
implements InternalUpdateHelper {
    private final InternalTransactionalEditingDomain domain;

    TransactionalUpdateHelper(InternalTransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public static TransactionalUpdateHelper create(Resource extensionResource) {
        TransactionalUpdateHelper result = null;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)extensionResource);
        if (domain instanceof InternalTransactionalEditingDomain) {
            result = new TransactionalUpdateHelper((InternalTransactionalEditingDomain)domain);
        }
        return result;
    }

    public void run(Object context, Runnable update) {
        InternalTransaction active = this.domain.getActiveTransaction();
        if (active != null && !active.isReadOnly()) {
            update.run();
        } else {
            try {
                InternalTransaction unprotected = this.domain.startTransaction(false, Collections.singletonMap("unprotected", true));
                try {
                    try {
                        update.run();
                    }
                    catch (RuntimeException e) {
                        active.rollback();
                        Activator.log.error("Uncaught exception in internal update helper. Update rolled back.", (Throwable)e);
                        throw e;
                    }
                }
                finally {
                    if (unprotected.isActive()) {
                        try {
                            unprotected.commit();
                        }
                        catch (RollbackException e) {
                            Activator.log.error("Update rolled back by commit validation.", (Throwable)e);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                Activator.log.error("Interrupted waiting for transaction.  Attempting update.", (Throwable)e);
                update.run();
            }
        }
    }
}

