/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal.types.advice;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IEditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeDependentsRequest;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.types.advice.IInheritanceEditHelperAdvice;
import org.eclipse.papyrusrt.umlrt.core.utils.StateUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.TransitionUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTVertex;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public class TransitionEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInheritanceEditHelperAdvice {
    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        ICommand result = this.getInheritanceEditCommand(request);
        if (result == null) {
            result = super.getBeforeEditCommand(request);
        }
        return result;
    }

    @Override
    public ICommand getExcludeDependentsCommand(ExcludeDependentsRequest request) {
        ICommand reinheritVertices;
        List verticesToReinherit;
        UMLRTTransition transition;
        ICommand result = IInheritanceEditHelperAdvice.super.getExcludeDependentsCommand(request);
        if (!request.isExclude() && request.getElementToExclude() instanceof Transition && (transition = UMLRTTransition.getInstance((Transition)((Transition)request.getElementToExclude()))) != null && !(verticesToReinherit = Stream.of(transition.getSource(), transition.getTarget()).filter(Objects::nonNull).filter(UMLRTNamedElement::isExcluded).map(UMLRTVertex::toUML).collect(Collectors.toList())).isEmpty() && (reinheritVertices = request.getExcludeDependentsCommand(verticesToReinherit)) != null) {
            result = CompositeCommand.compose((ICommand)result, (ICommand)reinheritVertices);
        }
        return result;
    }

    protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
        EObject initialTarget;
        EObject initialSource;
        IElementType type;
        IEditCommandRequest editCommandRequest = request.getEditCommandRequest();
        if (editCommandRequest instanceof CreateRelationshipRequest && ElementTypeUtils.isTypeCompatible(type = ((CreateRelationshipRequest)editCommandRequest).getElementType(), (IElementType)UMLElementTypes.TRANSITION) && !ElementTypeUtils.isTypeCompatible(type, (IElementType)UMLRTElementTypesEnumerator.TRANSITION_INTERNAL) && TransitionEditHelperAdvice.requiresPseudostateCreation(initialSource = ((CreateRelationshipRequest)editCommandRequest).getSource(), initialTarget = ((CreateRelationshipRequest)editCommandRequest).getTarget())) {
            CreateTransitionEndsContextCommand command = new CreateTransitionEndsContextCommand(request, initialSource, initialTarget);
            return command;
        }
        return super.getBeforeEditContextCommand(request);
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        Transition transition = (Transition)TypeUtils.as((Object)request.getElementToDestroy(), Transition.class);
        ArrayList<Vertex> toDestroy = new ArrayList<Vertex>();
        if (this.needsDestroyEnds(transition.getSource(), transition)) {
            toDestroy.add(transition.getSource());
        }
        if (this.needsDestroyEnds(transition.getTarget(), transition)) {
            toDestroy.add(transition.getTarget());
        }
        if (!toDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(toDestroy);
        }
        return null;
    }

    protected ICommand getDestroyCommand(Vertex vertex, DestroyDependentsRequest request) {
        DestroyElementRequest destroy = new DestroyElementRequest(request.getEditingDomain(), (EObject)vertex, request.isConfirmationRequired());
        destroy.addParameters(request.getParameters());
        destroy.setParameter("DestroyElementRequest.destroyDependentsRequest", (Object)request);
        destroy.setParameter("DestroyElementRequest.initialElementToDestroy", (Object)vertex);
        destroy.setClientContext(org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils.getEditContext());
        Object eHelperContext = destroy.getEditHelperContext();
        if (eHelperContext instanceof IEditHelperContext) {
            EObject o = ((IEditHelperContext)eHelperContext).getEObject();
            IElementType context = ElementTypeRegistry.getInstance().getElementType(o, org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils.getEditContext());
            if (context != null) {
                return context.getEditCommand((IEditCommandRequest)destroy);
            }
        }
        return null;
    }

    protected boolean needsDestroyEnds(Vertex source, Transition transition) {
        if (!(source instanceof Pseudostate)) {
            return false;
        }
        Pseudostate ps = (Pseudostate)source;
        PseudostateKind kind = ps.getKind();
        if (!PseudostateKind.ENTRY_POINT_LITERAL.equals((Object)kind) && !PseudostateKind.EXIT_POINT_LITERAL.equals((Object)kind)) {
            return false;
        }
        return !Stream.concat(ps.getOutgoings().stream(), ps.getIncomings().stream()).filter(t -> !t.equals(transition)).findAny().isPresent();
    }

    protected static boolean requiresPseudostateCreation(EObject initialSource, EObject initialTarget) {
        return TransitionEditHelperAdvice.requiresPseudoStateCreation(initialSource) || TransitionEditHelperAdvice.requiresPseudoStateCreation(initialTarget);
    }

    protected static boolean requiresPseudoStateCreation(EObject object) {
        return StateUtils.isCompositeState(object);
    }

    protected static ICommand getCreatePseudostateCommand(State initialTarget, CreateRelationshipRequest createRelationshipRequest, IHintedType type) {
        return ElementEditServiceUtils.getCreateChildCommandWithContext((EObject)initialTarget, (IHintedType)type);
    }

    public static class CreateTransitionEndsContextCommand
    extends GetEditContextCommand {
        private EObject initialSource;
        private EObject initialTarget;

        public CreateTransitionEndsContextCommand(GetEditContextRequest request, EObject initialSource, EObject initialTarget) {
            super(request);
            this.initialSource = initialSource;
            this.initialTarget = initialTarget;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ICommand targetCommand;
            Object result;
            IStatus status;
            EContentsEList regions;
            IHintedType type;
            CreateRelationshipRequest createRelationshipRequest = (CreateRelationshipRequest)((GetEditContextRequest)this.getRequest()).getEditCommandRequest();
            if (TransitionEditHelperAdvice.requiresPseudoStateCreation(this.initialSource)) {
                ICommand sourceCommand;
                type = UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_EXIT_POINT;
                regions = UMLRTExtensionUtil.getUMLRTContents((EObject)this.initialSource, (EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature[])new EStructuralFeature[0]);
                if (!regions.isEmpty() && regions.get(0) == createRelationshipRequest.getContainer() && TransitionUtils.getImplicitState(this.initialSource) != TransitionUtils.getImplicitState(this.initialTarget)) {
                    type = UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_ENTRY_POINT;
                }
                if ((sourceCommand = TransitionEditHelperAdvice.getCreatePseudostateCommand((State)this.initialSource, createRelationshipRequest, type)) == null || !sourceCommand.canExecute()) return CommandResult.newErrorCommandResult((String)"Command cannot be executed");
                status = sourceCommand.execute(monitor, info);
                if (!status.isOK()) return new CommandResult(status);
                result = sourceCommand.getCommandResult().getReturnValue();
                if (!(result instanceof Pseudostate)) return CommandResult.newErrorCommandResult((String)"result is not a pseudostate");
                Pseudostate exitPoint = (Pseudostate)result;
                createRelationshipRequest.setSource((EObject)exitPoint);
                createRelationshipRequest.setParameter("CreateRelationshipRequest.source", (Object)exitPoint);
            }
            if (!TransitionEditHelperAdvice.requiresPseudoStateCreation(this.initialTarget)) return CommandResult.newOKCommandResult((Object)this.getEditContext());
            type = UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_ENTRY_POINT;
            regions = UMLRTExtensionUtil.getUMLRTContents((EObject)this.initialTarget, (EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature[])new EStructuralFeature[0]);
            if (!regions.isEmpty() && regions.get(0) == createRelationshipRequest.getContainer() && TransitionUtils.getImplicitState(this.initialTarget) != TransitionUtils.getImplicitState(this.initialSource)) {
                type = UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_EXIT_POINT;
            }
            if ((targetCommand = TransitionEditHelperAdvice.getCreatePseudostateCommand((State)this.initialTarget, createRelationshipRequest, type)) == null || !targetCommand.canExecute()) return CommandResult.newErrorCommandResult((String)"Command cannot be executed");
            status = targetCommand.execute(monitor, info);
            if (!status.isOK()) return new CommandResult(status);
            result = targetCommand.getCommandResult().getReturnValue();
            if (!(result instanceof Pseudostate)) return CommandResult.newErrorCommandResult((String)"result is not a pseudostate");
            Pseudostate entryPoint = (Pseudostate)result;
            createRelationshipRequest.setTarget((EObject)entryPoint);
            createRelationshipRequest.setParameter("CreateRelationshipRequest.target", (Object)entryPoint);
            return CommandResult.newOKCommandResult((Object)this.getEditContext());
        }
    }
}

