/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;

public class EnumerationEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            return this.approveCreateElementRequest(request);
        }
        if (request instanceof MoveRequest) {
            return this.approveMoveRequest(request);
        }
        return super.approveRequest(request);
    }

    protected boolean approveCreateElementRequest(IEditCommandRequest request) {
        IElementType umlOperationType;
        CreateElementRequest createElementRequest = (CreateElementRequest)request;
        IElementType type = createElementRequest.getElementType();
        Element container = (Element)createElementRequest.getContainer();
        if (!UMLRTProfileUtils.isUMLRTProfileApplied(container)) {
            return super.approveRequest((IEditCommandRequest)createElementRequest);
        }
        IElementType umlAttributeType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.Property");
        if (umlAttributeType != null) {
            if (ElementTypeUtils.isTypeCompatible(type, umlAttributeType)) {
                return false;
            }
        } else {
            Activator.log.debug("Impossible to find element type for UML Attribute");
        }
        if ((umlOperationType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.Operation")) != null) {
            if (ElementTypeUtils.isTypeCompatible(type, umlOperationType)) {
                return false;
            }
        } else {
            Activator.log.debug("Impossible to find element type for UML Operation");
        }
        return super.approveRequest(request);
    }

    protected boolean approveMoveRequest(IEditCommandRequest request) {
        MoveRequest moveRequest = (MoveRequest)request;
        EObject targetContainer = moveRequest.getTargetContainer();
        if (targetContainer instanceof Element && !UMLRTProfileUtils.isUMLRTProfileApplied((Element)targetContainer)) {
            return super.approveRequest(request);
        }
        Map elementsToMove = moveRequest.getElementsToMove();
        for (Object elementToMove : elementsToMove.keySet()) {
            if (!(elementToMove instanceof Property) && !(elementToMove instanceof Operation)) continue;
            return false;
        }
        return super.approveRequest(request);
    }
}

