/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeDependentsRequest;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.advice.IInheritanceEditHelperAdvice;
import org.eclipse.papyrusrt.umlrt.core.utils.RegionUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLPackage;

public class RTStateEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInheritanceEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        Boolean result = null;
        if (request instanceof CreateElementRequest) {
            result = this.approveCreateElementRequest((CreateElementRequest)request);
        } else if (request instanceof MoveRequest) {
            result = this.approveMoveRequest((MoveRequest)request);
        } else if (request instanceof SetRequest) {
            result = this.approveSetRequest((SetRequest)request);
        }
        if (result == null) {
            result = super.approveRequest(request);
        }
        return result;
    }

    protected boolean approveSetRequest(SetRequest request) {
        EStructuralFeature feature = request.getFeature();
        for (Object o : request.getElementsToEdit()) {
            if (!(o instanceof State) || !UMLPackage.Literals.STATE__CONNECTION_POINT.equals(feature)) continue;
            return false;
        }
        return super.approveRequest((IEditCommandRequest)request);
    }

    protected boolean approveMoveRequest(MoveRequest request) {
        return RegionUtils.shouldApproveMoveRequest(request);
    }

    private Boolean approveCreateElementRequest(CreateElementRequest request) {
        Boolean result = null;
        IElementType typeToCreate = request.getElementType();
        if (ElementTypeUtils.isTypeCompatible(typeToCreate, (IElementType)UMLElementTypes.REGION) && request.getContainer() instanceof State) {
            State stateToEdit = (State)request.getContainer();
            result = !stateToEdit.isComposite();
        }
        return result;
    }

    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        ICommand result = this.getInheritanceEditCommand(request);
        if (result == null) {
            result = super.getBeforeEditCommand(request);
        }
        return result;
    }

    @Override
    public ICommand getExcludeDependentsCommand(ExcludeDependentsRequest request) {
        UMLRTState state;
        ICommand result = IInheritanceEditHelperAdvice.super.getExcludeDependentsCommand(request);
        if (request.isExclude() && request.getElementToExclude() instanceof State && (state = UMLRTState.getInstance((State)((State)request.getElementToExclude()))) != null) {
            ICommand excludeTransitions;
            Predicate<UMLRTNamedElement> alreadyExcluded = UMLRTNamedElement::isExcluded;
            List transitionsToExclude = Stream.concat(state.getIncomings().stream(), state.getOutgoings().stream()).distinct().filter(alreadyExcluded.negate()).map(UMLRTTransition::toUML).collect(Collectors.toList());
            List connectionPointTransitions = Stream.concat(state.getEntryPoints().stream().flatMap(cp -> cp.getIncomings().stream()), state.getExitPoints().stream().flatMap(cp -> cp.getOutgoings().stream())).distinct().filter(alreadyExcluded.negate()).map(UMLRTTransition::toUML).collect(Collectors.toList());
            if (!connectionPointTransitions.isEmpty()) {
                if (transitionsToExclude.isEmpty()) {
                    transitionsToExclude = connectionPointTransitions;
                } else {
                    transitionsToExclude.addAll(connectionPointTransitions);
                }
            }
            if (!transitionsToExclude.isEmpty() && (excludeTransitions = request.getExcludeDependentsCommand(transitionsToExclude)) != null) {
                result = CompositeCommand.compose((ICommand)result, (ICommand)excludeTransitions);
            }
        }
        return result;
    }

    public void configureRequest(IEditCommandRequest request) {
        if (request instanceof MoveRequest) {
            StateMachineUtils.retargetToRegion((MoveRequest)request);
        }
    }
}

