/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class EMFHacks {
    private EMFHacks() {
    }

    public static boolean isReadWriteTransactionActive(EObject object) {
        InternalTransaction active;
        InternalTransactionalEditingDomain domain = (InternalTransactionalEditingDomain)TypeUtils.as((Object)TransactionUtil.getEditingDomain((EObject)object), InternalTransactionalEditingDomain.class);
        InternalTransaction internalTransaction = active = domain == null ? null : domain.getActiveTransaction();
        return active != null && !active.isReadOnly();
    }

    public static <T extends Notifier> T silently(T notifier, Consumer<? super T> action) {
        boolean wasDeliver = notifier.eDeliver();
        notifier.eSetDeliver(false);
        try {
            action.accept(notifier);
        }
        finally {
            notifier.eSetDeliver(wasDeliver);
        }
        return notifier;
    }

    public static <T extends Notifier> Optional<T> silently(Optional<T> notifier, Consumer<? super T> action) {
        notifier.ifPresent(n -> {
            Notifier notifier = EMFHacks.silently(n, action);
        });
        return notifier;
    }

    public static ConeOfSilence coneOfSilence(Notifier ... notifiers) {
        return new ConeOfSilence(notifiers);
    }

    public static void notifyAdded(EObject newObject) {
        InternalEObject notifier = (InternalEObject)newObject.eContainer();
        if (notifier == null) {
            throw new IllegalArgumentException("newObject is not attached");
        }
        EReference containment = newObject.eContainmentFeature();
        int index = containment.isMany() ? ((List)notifier.eGet((EStructuralFeature)containment)).indexOf(newObject) : -1;
        ENotificationImpl notification = new ENotificationImpl(notifier, 3, (EStructuralFeature)containment, null, (Object)newObject, index);
        notifier.eNotify((Notification)notification);
    }

    public static final class ConeOfSilence
    implements Executor {
        private final List<Notifier> scope;

        ConeOfSilence(Notifier ... notifiers) {
            this.scope = Stream.of(notifiers).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public ConeOfSilence with(Notifier ... notifiers) {
            int i = 0;
            while (i < notifiers.length) {
                if (notifiers[i] != null) {
                    this.scope.add(notifiers[i]);
                }
                ++i;
            }
            return this;
        }

        @Override
        public void execute(Runnable command) {
            Boolean[] wasDeliver = (Boolean[])this.scope.stream().map(Notifier::eDeliver).toArray(Boolean[]::new);
            this.scope.forEach(n -> n.eSetDeliver(false));
            try {
                command.run();
            }
            catch (Throwable throwable) {
                IntStream.range(0, wasDeliver.length).forEach(i -> this.scope.get(i).eSetDeliver(wasDeliver[i].booleanValue()));
                throw throwable;
            }
            IntStream.range(0, wasDeliver.length).forEach(i -> this.scope.get(i).eSetDeliver(wasDeliver[i].booleanValue()));
        }
    }
}

