/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelUtils {
    private ModelUtils() {
    }

    public static Stream<EObject> containersOf(EObject object) {
        return ModelUtils.selfAndContainersOf(object.eContainer());
    }

    public static Stream<EObject> selfAndContainersOf(EObject object) {
        Iterator<EObject> containers = new Iterator<EObject>(object){
            EObject next;
            {
                this.next = eObject;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public EObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                EObject result = this.next;
                this.next = result.eContainer();
                return result;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(containers, 1296), false);
    }

    public static EObject create(EObject context, EClass eclass) {
        return context == null ? EcoreUtil.create((EClass)eclass) : ModelUtils.create(context.eResource(), eclass);
    }

    public static EObject create(Resource context, EClass eclass) {
        return context == null ? EcoreUtil.create((EClass)eclass) : ModelUtils.create(context.getResourceSet(), eclass);
    }

    public static EObject create(ResourceSet context, EClass eclass) {
        EFactory factory;
        EObject result = context == null ? EcoreUtil.create((EClass)eclass) : ((factory = context.getPackageRegistry().getEFactory(eclass.getEPackage().getNsURI())) == null ? EcoreUtil.create((EClass)eclass) : factory.create(eclass));
        return result;
    }
}

