/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Package;

public class PackageUtils {
    private PackageUtils() {
    }

    public static Set<Collaboration> getProtocols(Package containerPackage) {
        HashSet<Collaboration> result = new HashSet<Collaboration>();
        for (Package protocolContainer : PackageUtils.getProtocolContainers(containerPackage)) {
            Collaboration protocol = ProtocolContainerUtils.getProtocol(protocolContainer);
            if (protocol == null) continue;
            result.add(protocol);
        }
        return result;
    }

    public static Set<Package> getProtocolContainers(Package containerPackage) {
        if (containerPackage == null) {
            return Collections.emptySet();
        }
        HashSet<Package> result = new HashSet<Package>();
        for (Package nestedPackage : containerPackage.getNestedPackages()) {
            if (!ProtocolContainerUtils.isProtocolContainer((EObject)nestedPackage)) continue;
            result.add(nestedPackage);
        }
        return result;
    }

    public static Collaboration getProtocol(Package containerPackage, String name) {
        Set<Collaboration> protocols = PackageUtils.getProtocols(containerPackage);
        for (Collaboration protocol : protocols) {
            String protocolName = protocol.getName();
            if (protocolName == null || !protocolName.equals(name)) continue;
            return protocol;
        }
        return null;
    }
}

