/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.custom;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ISemanticObjectLabelProvider;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.UMLRTDiagramChangeItemProvider;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.custom.ProtocolChangeCustomItemProvider;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.custom.ProtocolMessageChangeCustomItemProvider;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.custom.ProtocolMessageParameterChangeCustomItemProvider;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.custom.UMLRTDiagramChangeCustomItemProvider;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.custom.UMLRTDiffCustomItemProvider;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.util.UMLRTCompareAdapterFactory;

public class UMLRTCompareCustomItemProviderAdapterFactory
extends UMLRTCompareAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected Disposable disposable = new Disposable();
    private ComposedAdapterFactory parentAdapterFactory;
    private IChangeNotifier changeNotifier = new ChangeNotifier();
    private Collection<Object> supportedTypes = new ArrayList<Object>();
    private ItemProviderAdapter diagramChangeItemProvider;

    public UMLRTCompareCustomItemProviderAdapterFactory() {
        this.supportedTypes.add(IItemStyledLabelProvider.class);
        this.supportedTypes.add(IItemDescriptionProvider.class);
        this.supportedTypes.add(ISemanticObjectLabelProvider.class);
    }

    public Adapter createUMLRTDiffAdapter() {
        return new UMLRTDiffCustomItemProvider((AdapterFactory)this);
    }

    public Adapter createProtocolChangeAdapter() {
        return new ProtocolChangeCustomItemProvider((AdapterFactory)this);
    }

    public Adapter createProtocolMessageChangeAdapter() {
        return new ProtocolMessageChangeCustomItemProvider((AdapterFactory)this);
    }

    public Adapter createProtocolMessageParameterChangeAdapter() {
        return new ProtocolMessageParameterChangeCustomItemProvider((AdapterFactory)this);
    }

    public Adapter createUMLRTDiagramChangeAdapter() {
        return new UMLRTDiagramChangeCustomItemProvider(this.getDiagramChangeAdapter());
    }

    public void dispose() {
        this.disposable.dispose();
    }

    protected ItemProviderAdapter getDiagramChangeAdapter() {
        if (this.diagramChangeItemProvider == null) {
            this.diagramChangeItemProvider = new UMLRTDiagramChangeItemProvider((AdapterFactory)this);
        }
        return this.diagramChangeItemProvider;
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        if (this.parentAdapterFactory == null) {
            return this;
        }
        return this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    protected void associate(Adapter adapter, Notifier target) {
        super.associate(adapter, target);
        if (adapter != null) {
            this.disposable.add((Object)adapter);
        }
    }
}

