/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.AbstractCapsuleDiagramChangeHandler;
import org.eclipse.uml2.uml.Classifier;

public class CapsuleShapeChangeHandler
extends AbstractCapsuleDiagramChangeHandler {
    @Override
    public double isHandlerFor(Diff diff) {
        if (this.isReferenceChangeOfCapsuleShape(diff)) {
            return 10.0;
        }
        return Double.NaN;
    }

    private boolean isReferenceChangeOfCapsuleShape(Diff input) {
        if (!(input instanceof ReferenceChange) || !this.hasDiagramContainer(input)) {
            return false;
        }
        EObject value = ((ReferenceChange)input).getValue();
        if (!(value instanceof Shape)) {
            return false;
        }
        EObject element = ((Shape)value).getElement();
        return element instanceof Classifier && CapsuleUtils.isCapsule((Classifier)((Classifier)element));
    }

    private boolean hasDiagramContainer(Diff input) {
        EObject container = MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (Diff)input);
        return container instanceof Diagram && ReferenceUtil.safeEGet((EObject)container, (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT) != null;
    }

    @Override
    public Set<EObject> getShapes(Diff diff) {
        LinkedHashSet<EObject> shapes = new LinkedHashSet<EObject>();
        ReferenceChange refChange = (ReferenceChange)diff;
        Shape capsuleShape = (Shape)refChange.getValue();
        shapes.add((EObject)capsuleShape);
        shapes.addAll(this.collectAdditionalShapesForElement(capsuleShape.getDiagram(), (Classifier)capsuleShape.getElement()));
        return shapes;
    }

    @Override
    public Set<EObject> getAutomaticallyCreatedShapes(Diff diff) {
        return Collections.emptySet();
    }

    private Collection<? extends EObject> collectAdditionalShapesForElement(Diagram container, Classifier capsule) {
        LinkedHashSet<EObject> shapes = new LinkedHashSet<EObject>();
        for (Object child : container.getChildren()) {
            EObject eObject;
            if (!(child instanceof EObject) || !this.isShapeWithElement(eObject = (EObject)child, (EObject)capsule)) continue;
            shapes.add(eObject);
        }
        for (Object edge : container.getEdges()) {
            if (!(edge instanceof Edge) || !this.isStereotypeCommentEdge((EObject)edge, (EObject)capsule)) continue;
            shapes.add((EObject)edge);
        }
        return shapes;
    }
}

