/*****************************************************************************
 * Copyright (c) 2017 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.canonical.editpolicy.PapyrusCanonicalEditPolicy;

/**
 * A specialized <em>Canonical Edit-Policy</em> that accounts for inheritance semantics
 * of UML-RT.
 */
public class PapyrusRTCanonicalEditPolicy extends PapyrusCanonicalEditPolicy {

	public PapyrusRTCanonicalEditPolicy() {
		super();
	}

	/**
	 * Resolves the edit-part to the local inherited or overriding definition
	 * of an the notation view's element in the case that such element is
	 * the root definition, not the definition in context.
	 */
	@Override
	public EObject getSemanticHost() {
		IGraphicalEditPart host = host();

		if (host instanceof ShapeCompartmentEditPart) {
			// Resolve from the parent because it should be inheritable
			if (host.getParent() instanceof IGraphicalEditPart) {
				host = (IGraphicalEditPart) host.getParent();
			}
		}

		return host.resolveSemanticElement();
	}

	@Override
	protected CreateRequest createCreateRequest(ViewDescriptor viewDescriptor) {
		CreateRequest result = super.createCreateRequest(viewDescriptor);

		// Mark this create request as originating from Canonical Edit Policy
		@SuppressWarnings("unchecked")
		Map<Object, Object> extendedData = result.getExtendedData();
		extendedData.put(EditPolicyRoles.CANONICAL_ROLE, true);

		return result;
	}
}
