/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.drop;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateCapsulePartAndDisplayCommand
extends AbstractCommand {
    protected Classifier targetClassifier;
    protected String capsulePartId;
    protected EReference classifier_Feature;
    protected EObject droppedObject;
    protected Point location;
    protected EditPart targetEditPart;

    public CreateCapsulePartAndDisplayCommand(Classifier targetClassifier, String capsulePartId, EReference classifier_Feature, EObject droppedObject, Point location, EditPart targetEditPart) {
        super("");
        this.targetClassifier = targetClassifier;
        this.capsulePartId = capsulePartId;
        this.classifier_Feature = classifier_Feature;
        this.droppedObject = droppedObject;
        this.location = new Point(location);
        this.targetEditPart = targetEditPart;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)this.targetClassifier);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return CommandResult.newErrorCommandResult((Throwable)e);
        }
        Property capsulePart = this.createCapsulePart(editingDomain);
        this.setCapsuleAsType(editingDomain, capsulePart, this.droppedObject);
        this.dropCapsulePart(capsulePart);
        UMLRTEditPartUtils.scheduleDirectEdit(this.targetEditPart, (EObject)capsulePart);
        return CommandResult.newOKCommandResult((Object)capsulePart);
    }

    protected void setCapsuleAsType(TransactionalEditingDomain editingDomain, Property capsulePart, EObject type) {
        ICommand setCommand;
        SetRequest setRequest = new SetRequest(editingDomain, (EObject)capsulePart, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)type);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.targetClassifier);
        if (provider != null && (setCommand = provider.getEditCommand((IEditCommandRequest)setRequest)) != null && setCommand.canExecute()) {
            try {
                setCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected void dropCapsulePart(Property createdCapsulePart) {
        DropObjectsRequest dropReq = new DropObjectsRequest();
        dropReq.setObjects(Arrays.asList(createdCapsulePart));
        dropReq.setLocation(this.location);
        Command dropReqCommand = this.targetEditPart.getCommand((Request)dropReq);
        if (dropReqCommand != null && dropReqCommand.canExecute()) {
            dropReqCommand.execute();
        }
    }

    protected Property createCapsulePart(TransactionalEditingDomain editingDomain) {
        ICommand createCommand;
        Property createdProperty = null;
        CreateElementRequest createElementRequest = new CreateElementRequest(editingDomain, (EObject)this.targetClassifier, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.CapsulePart"));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.targetClassifier);
        if (provider != null && (createCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest)) != null && createCommand.canExecute()) {
            try {
                createCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
            CommandResult result = createCommand.getCommandResult();
            createdProperty = (Property)CreateCapsulePartAndDisplayCommand.getCreatedObject(result);
            return createdProperty;
        }
        return createdProperty;
    }

    public static <T extends EObject> T getCreatedObject(CommandResult commandResult) {
        Object objectResult = commandResult.getReturnValue();
        if (objectResult instanceof List) {
            List listResult = (List)objectResult;
            for (Object elementResult : listResult) {
                EObject newElement;
                CreateElementRequest request;
                if (!(elementResult instanceof CreateElementRequestAdapter) || (request = (CreateElementRequest)((CreateElementRequestAdapter)elementResult).getAdapter(CreateElementRequest.class)) == null || !((newElement = request.getNewElement()) instanceof EObject)) continue;
                return (T)newElement;
            }
        } else if (commandResult.getReturnValue() instanceof EObject) {
            return (T)((EObject)commandResult.getReturnValue());
        }
        return null;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

