/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public interface IRTPortEditPart
extends IGraphicalEditPart {
    default public Port getPort() {
        return (Port)this.resolveSemanticElement();
    }

    default public boolean isPortOnPart() {
        boolean result = false;
        EditPart parent = this.getParent();
        if (parent instanceof IGraphicalEditPart) {
            EObject parentElement = ((IGraphicalEditPart)parent).resolveSemanticElement();
            result = parentElement instanceof Property && CapsulePartUtils.isCapsulePart((Property)((Property)parentElement));
        }
        return result;
    }

    default public boolean isPortOnCapsule() {
        return this.getPort() != null && !this.isPortOnPart();
    }

    public static boolean isPortOnPart(EditPart editPart) {
        return editPart instanceof IRTPortEditPart && ((IRTPortEditPart)editPart).isPortOnPart();
    }

    public static boolean isPortOnCapsule(EditPart editPart) {
        return editPart instanceof IRTPortEditPart && ((IRTPortEditPart)editPart).isPortOnCapsule();
    }

    default public Dimension getDefaultSize() {
        return IRTPortEditPart.getDefaultSize(this.isPortOnPart());
    }

    public static Dimension getDefaultSize(boolean portOnPart) {
        return portOnPart ? new Dimension(11, 11) : new Dimension(16, 16);
    }

    default public double getDefaultScaleFactor() {
        return IRTPortEditPart.getDefaultScaleFactor(this.isPortOnPart());
    }

    public static double getDefaultScaleFactor(boolean portOnPart) {
        return portOnPart ? 0.55 : 0.8;
    }
}

