/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.AbstractInheritanceEditPolicy;

public class EdgeInheritanceEditPolicy
extends AbstractInheritanceEditPolicy<Edge> {
    private static final Set<EReference> CONTAINMENTS = ImmutableSet.of((Object)NotationPackage.Literals.EDGE__SOURCE_ANCHOR, (Object)NotationPackage.Literals.EDGE__TARGET_ANCHOR, (Object)NotationPackage.Literals.EDGE__BENDPOINTS);

    public EdgeInheritanceEditPolicy() {
        super(Edge.class);
    }

    @Override
    protected boolean shouldListen(Edge view, EReference containment) {
        return CONTAINMENTS.contains(containment);
    }

    @Override
    protected Command update(EObject inherited) {
        ICommand result = null;
        if (inherited instanceof IdentityAnchor) {
            IdentityAnchor anchor;
            result = this.getUpdateCommand(anchor, (anchor = (IdentityAnchor)inherited).eContainmentFeature() == NotationPackage.Literals.EDGE__TARGET_ANCHOR);
        } else if (inherited instanceof RelativeBendpoints) {
            RelativeBendpoints bendpoints = (RelativeBendpoints)inherited;
            result = this.getUpdateCommand(bendpoints);
        } else if (inherited instanceof RoutingStyle) {
            RoutingStyle routing = (RoutingStyle)inherited;
            result = this.getUpdateCommand(routing);
        }
        return result == null ? null : GMFtoEMFCommandWrapper.wrap((ICommand)result);
    }

    @Override
    protected boolean isVisualEdit(Request request) {
        return "create bendpoint".equals(request.getType()) || "move bendpoint".equals(request.getType());
    }

    ICommand getUpdateCommand(IdentityAnchor anchor, boolean isTarget) {
        IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
        Edge edge = (Edge)this.getView();
        TransactionalEditingDomain domain = host.getEditingDomain();
        SetConnectionAnchorsCommand result = null;
        if (!EcoreUtil.equals((EObject)anchor, (EObject)(isTarget ? edge.getTargetAnchor() : edge.getSourceAnchor()))) {
            SetConnectionAnchorsCommand command = new SetConnectionAnchorsCommand(domain, "Follow inherited anchor");
            command.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)edge));
            if (isTarget) {
                command.setNewTargetTerminal(anchor.getId());
            } else {
                command.setNewSourceTerminal(anchor.getId());
            }
            result = command;
        }
        return result != null && result.canExecute() ? result : null;
    }

    ICommand getUpdateCommand(RelativeBendpoints bendpoints) {
        IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
        Edge edge = (Edge)this.getView();
        TransactionalEditingDomain domain = host.getEditingDomain();
        Command result = null;
        if (!EcoreUtil.equals((EObject)bendpoints, (EObject)edge.getBendpoints())) {
            result = SetCommand.create((EditingDomain)domain, (Object)edge.getBendpoints(), (Object)NotationPackage.Literals.RELATIVE_BENDPOINTS__POINTS, (Object)bendpoints.getPoints());
        }
        return result != null && result.canExecute() ? EMFtoGMFCommandWrapper.wrap(result) : null;
    }

    ICommand getUpdateCommand(RoutingStyle routing) {
        IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
        Edge edge = (Edge)this.getView();
        TransactionalEditingDomain domain = host.getEditingDomain();
        Command result = null;
        RoutingStyle myRouting = (RoutingStyle)edge.getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (myRouting != null) {
            CompoundCommand cc = new CompoundCommand();
            if (myRouting.getRouting() != routing.getRouting()) {
                cc.append(SetCommand.create((EditingDomain)domain, (Object)myRouting, (Object)NotationPackage.Literals.ROUTING_STYLE__ROUTING, (Object)routing.getRouting()));
            }
            if (myRouting.getJumpLinkStatus() != routing.getJumpLinkStatus()) {
                cc.append(SetCommand.create((EditingDomain)domain, (Object)myRouting, (Object)NotationPackage.Literals.ROUTING_STYLE__JUMP_LINK_STATUS, (Object)routing.getJumpLinkStatus()));
            }
            if (myRouting.getJumpLinkType() != routing.getJumpLinkType()) {
                cc.append(SetCommand.create((EditingDomain)domain, (Object)myRouting, (Object)NotationPackage.Literals.ROUTING_STYLE__JUMP_LINK_TYPE, (Object)routing.getJumpLinkType()));
            }
            if (myRouting.isJumpLinksReverse() != routing.isJumpLinksReverse()) {
                cc.append(SetCommand.create((EditingDomain)domain, (Object)myRouting, (Object)NotationPackage.Literals.ROUTING_STYLE__JUMP_LINKS_REVERSE, (Object)routing.isJumpLinksReverse()));
            }
            if (myRouting.isAvoidObstructions() != routing.isAvoidObstructions()) {
                cc.append(SetCommand.create((EditingDomain)domain, (Object)myRouting, (Object)NotationPackage.Literals.ROUTING_STYLE__AVOID_OBSTRUCTIONS, (Object)routing.isAvoidObstructions()));
            }
            if (myRouting.isClosestDistance() != routing.isClosestDistance()) {
                cc.append(SetCommand.create((EditingDomain)domain, (Object)myRouting, (Object)NotationPackage.Literals.ROUTING_STYLE__CLOSEST_DISTANCE, (Object)routing.isClosestDistance()));
            }
            if (myRouting.getRoundedBendpointsRadius() != routing.getRoundedBendpointsRadius()) {
                cc.append(SetCommand.create((EditingDomain)domain, (Object)myRouting, (Object)NotationPackage.Literals.ROUTING_STYLE__ROUNDED_BENDPOINTS_RADIUS, (Object)routing.getRoundedBendpointsRadius()));
            }
            if (myRouting.getSmoothness() != routing.getSmoothness()) {
                cc.append(SetCommand.create((EditingDomain)domain, (Object)myRouting, (Object)NotationPackage.Literals.ROUTING_STYLE__SMOOTHNESS, (Object)routing.getSmoothness()));
            }
            result = cc.unwrap();
        }
        return result != null && result.canExecute() ? EMFtoGMFCommandWrapper.wrap(result) : null;
    }
}

