/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.figures;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;

public class OnConnectionFixedLocator
extends ConnectionLocator {
    private double distanceFromEnd;
    private boolean isSourceEnd;

    public OnConnectionFixedLocator(Connection connection, double distanceFromSource) {
        this(connection, distanceFromSource, true);
    }

    public OnConnectionFixedLocator(Connection connection, double distanceFromEnd, boolean isSourceEnd) {
        super(connection);
        this.distanceFromEnd = distanceFromEnd;
        this.isSourceEnd = isSourceEnd;
    }

    protected Point getLocation(PointList points) {
        PointList copyPoints = PointListUtilities.copyPoints((PointList)points);
        double dist = PointListUtilities.getPointsLength((PointList)copyPoints);
        double position = this.isSourceEnd() ? this.getDistanceFromEnd() / dist * 100.0 : 100.0 - this.getDistanceFromEnd() / dist * 100.0;
        int percentage = Math.toIntExact(Math.round(position));
        Point p = PointListUtilities.calculatePointRelativeToLine((PointList)copyPoints, (int)0, (int)percentage, (boolean)true);
        return p;
    }

    protected double getDistanceFromEnd() {
        return this.distanceFromEnd;
    }

    protected boolean isSourceEnd() {
        return this.isSourceEnd;
    }
}

