/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.handlers;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.ui.util.EclipseCommandUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleInheritViewHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        List<IInheritableEditPart> editParts = this.getInheritableEditParts(selection);
        if (!editParts.isEmpty()) {
            TransactionalEditingDomain domain = editParts.get(0).getEditingDomain();
            List<Boolean> states = this.getInheritanceStates(editParts);
            if (domain != null && !states.isEmpty()) {
                boolean groundState = states.get(0);
                Function<View, org.eclipse.emf.common.command.Command> commandFuntion = groundState ? IInheritableEditPart.StyleUtil::getCreateInheritedStyle : IInheritableEditPart.StyleUtil::getDeleteInheritedStyle;
                Predicate<IInheritableEditPart> needsChange = iep -> iep.isInherited() == groundState;
                org.eclipse.emf.common.command.Command command = editParts.stream().filter(needsChange).map(IGraphicalEditPart::getNotationView).map(commandFuntion).reduce(org.eclipse.emf.common.command.Command::chain).orElse((org.eclipse.emf.common.command.Command)UnexecutableCommand.INSTANCE);
                if (command.canExecute()) {
                    domain.getCommandStack().execute(command);
                }
            }
        }
        return null;
    }

    private List<IInheritableEditPart> getInheritableEditParts(IStructuredSelection selection) {
        return this.inheritableEditParts(selection).collect(Collectors.toList());
    }

    private Stream<IInheritableEditPart> inheritableEditParts(IStructuredSelection selection) {
        Predicate<IInheritableEditPart> isDependent = IInheritableEditPart::isDependentChild;
        return selection.toList().stream().filter(IInheritableEditPart.class::isInstance).map(IInheritableEditPart.class::cast).filter(IInheritableEditPart::canInherit).filter(isDependent.negate());
    }

    private List<Boolean> getInheritanceStates(IStructuredSelection selection) {
        return this.inheritableEditParts(selection).map(IInheritableEditPart::isInherited).distinct().sorted(ToggleInheritViewHandler.followBias()).collect(Collectors.toList());
    }

    private List<Boolean> getInheritanceStates(List<? extends IInheritableEditPart> editParts) {
        return editParts.stream().map(IInheritableEditPart::isInherited).distinct().sorted(ToggleInheritViewHandler.followBias()).collect(Collectors.toList());
    }

    private static Comparator<Boolean> followBias() {
        return Comparator.naturalOrder();
    }

    public void setEnabled(Object context) {
        boolean enable;
        Object sel = HandlerUtil.getVariable((Object)context, (String)"selection");
        StructuredSelection selection = sel instanceof IStructuredSelection ? (IStructuredSelection)sel : StructuredSelection.EMPTY;
        List<Boolean> states = this.getInheritanceStates((IStructuredSelection)selection);
        boolean bl = enable = !states.isEmpty();
        if (enable) {
            Command command = EclipseCommandUtils.getCommandService().getCommand("org.eclipse.papyrusrt.umlrt.tooling.diagram.common.toggleInheritView");
            if (command == null) {
                enable = false;
            } else {
                EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)states.get(0));
            }
        }
        this.setBaseEnabled(enable);
    }
}

