/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.layout;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IRTPortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.layout.AbstractPortOnCapsuleLayoutProvider;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.LinearIterator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class InternalPortOnCapsuleLayoutProvider
extends AbstractPortOnCapsuleLayoutProvider {
    @Override
    public boolean isValidPort(Node node) {
        Optional<RTPortKindEnum> kind = Optional.ofNullable(RTPortUtils.getKind((Port)((Port)TypeUtils.as((Object)node.getElement(), Port.class))));
        return kind.map(RTPortKindEnum::isInternal).orElse(false);
    }

    @Override
    public Command getPortLayoutCommand(IGraphicalEditPart capsule, List<IGraphicalEditPart> ports) {
        CompositeCommand result = new CompositeCommand("Arrange Ports");
        int stride = IRTPortEditPart.getDefaultSize((boolean)false).width * 8 / 3;
        Predicate<Point> hitPort = pt -> UMLRTEditPartUtils.findChildAt(capsule, pt).map(IGraphicalEditPart::getNotationView).map(View::getElement).filter(Property.class::isInstance).isPresent();
        LinearIterator locationIterator = LinearIterator.from(new Point(0, 0), hitPort);
        for (IGraphicalEditPart next : ports) {
            result.add((IUndoableOperation)new SetBoundsCommand(capsule.getEditingDomain(), result.getLabel(), (IAdaptable)new EObjectAdapter((EObject)next.getNotationView()), locationIterator.next(stride)));
        }
        return result.isEmpty() ? null : new ICommandProxy((ICommand)result);
    }
}

