/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils;

import java.util.function.Predicate;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.ILocationIterator;

public class LinearIterator
implements ILocationIterator {
    private final double unitX;
    private final double unitY;
    private final Point origin;
    private double current;
    private Predicate<? super Point> hitDetect;

    private LinearIterator(double angle, Point start) {
        this.unitX = Math.cos(angle);
        this.unitY = Math.sin(angle);
        this.origin = start.getCopy();
    }

    private LinearIterator(double angle, Point start, Predicate<? super Point> hitDetect) {
        this.unitX = Math.cos(angle);
        this.unitY = Math.sin(angle);
        this.origin = start.getCopy();
        this.hitDetect = hitDetect;
    }

    public static LinearIterator from(Point startingAt, double direction) {
        return new LinearIterator(direction, startingAt);
    }

    public static LinearIterator from(Point startingAt, double direction, Predicate<? super Point> hitDetect) {
        return new LinearIterator(direction, startingAt, hitDetect);
    }

    public static LinearIterator from(Point startingAt) {
        return LinearIterator.from(startingAt, 0.7853981633974483);
    }

    public static LinearIterator from(Point startingAt, Predicate<? super Point> hitDetect) {
        return LinearIterator.from(startingAt, 0.7853981633974483, hitDetect);
    }

    @Override
    public Point next(double distance) {
        if (this.hitDetect != null) {
            Point here = this.where();
            do {
                this.current += distance;
            } while (this.hitDetect.test((Point)(here = this.where())));
            return here;
        }
        this.current += distance;
        return this.where();
    }

    @Override
    public Point where() {
        return this.origin.getTranslated(this.unitX * this.current, this.unitY * this.current);
    }
}

