/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLViewProvider;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.InternalTransitionsCompartmentEditPart;

/**
 * Specific view provider that extends the creation of states as shape.
 * <br/>
 * It will create from the begining the compartment for internal transitions, rather than waiting the defered creation commande with unsafe write
 */
public class UMLRTStateMachineViewProvider extends UMLViewProvider {

	/**
	 * Constructor.
	 */
	public UMLRTStateMachineViewProvider() {
		super();
	}

	@Override
	public Node createState_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
		Node node = super.createState_Shape(domainElement, containerView, index, persisted, preferencesHint);
		// complete with creation of the internal transition compartment
		createInternalTransitionCompartment(node);
		return node;
	}

	@Override
	public Node createState_Shape_TN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
		Node node = super.createState_Shape_TN(domainElement, containerView, index, persisted, preferencesHint);
		// complete with creation of the internal transition compartment
		createInternalTransitionCompartment(node);
		return node;
	}

	/**
	 * @param node
	 *            the state view on which to create the compartment for internal transitions
	 */
	protected void createInternalTransitionCompartment(Node node) {
		Node rv = NotationFactory.eINSTANCE.createCompartment();
		rv.setLayoutConstraint(NotationFactory.eINSTANCE.createBounds());
		rv.setType(InternalTransitionsCompartmentEditPart.VISUAL_ID);
		ViewUtil.insertChildView(node, rv, ViewUtil.APPEND, true);
	}
}
