/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands;

import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.helper.EditorHyperLinkHelper;
import org.eclipse.papyrusrt.umlrt.core.utils.RegionUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTStateMachineDiagramUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateNestedStateMachineDiagramCommand
extends AbstractTransactionalCommand {
    private final State state;
    private final IGraphicalEditPart stateEditPart;
    private final boolean openDiagram;

    public CreateNestedStateMachineDiagramCommand(TransactionalEditingDomain domain, State state, IGraphicalEditPart stateEditPart, boolean openDiagram) {
        super(domain, "Create State Machine Diagram", CreateNestedStateMachineDiagramCommand.getWorkspaceFiles(Arrays.asList(state, stateEditPart.getNotationView())));
        this.state = state;
        this.stateEditPart = stateEditPart;
        this.openDiagram = openDiagram;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View stateView = this.stateEditPart.getNotationView();
        UMLRTState facade = UMLRTState.getInstance((State)this.state);
        if (facade == null) {
            return CommandResult.newErrorCommandResult((String)"Cannot redefine state");
        }
        facade.reify();
        UMLRTExtensionUtil.getUMLRTContents((EObject)this.state, (EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature[])new EStructuralFeature[0]).stream().forEach(UMLRTExtensionUtil::touch);
        Diagram result = UMLRTStateMachineDiagramUtils.createStateMachineDiagram((EObject)this.state, null);
        if (result != null) {
            EditorHyperLinkHelper helper;
            Command hyperlink;
            UMLRTExtensionUtil.getUMLRTContents((EObject)this.state, (EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature[])new EStructuralFeature[0]).forEach(RegionUtils::applyStereotype);
            if (this.openDiagram) {
                try {
                    IPageManager pages = ServiceUtilsForEObject.getInstance().getIPageManager((Object)result);
                    pages.openPage((Object)result);
                }
                catch (ServiceException e) {
                    return CommandResult.newErrorCommandResult((Throwable)e);
                }
            }
            if ((hyperlink = (helper = new EditorHyperLinkHelper()).getCreateHyperlinkCommand(this.getEditingDomain(), (EModelElement)stateView, (Object)result)) != null && hyperlink.canExecute()) {
                hyperlink.execute();
            }
        }
        return result == null ? CommandResult.newCancelledCommandResult() : CommandResult.newOKCommandResult((Object)result);
    }
}

