/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticElementAdapter;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnectionPoint;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnectionPointKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTVertex;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLPackage;

public class RerouteTransitionsToConnectionPointsCommand {
    private RerouteTransitionsToConnectionPointsCommand() {
    }

    public static ICommand createRerouteTransitionsCommand(TransactionalEditingDomain domain, State state, IGraphicalEditPart stateEditPart) {
        ICommand result = null;
        UMLRTState rtState = UMLRTState.getInstance((State)state);
        if (rtState == null) {
            return result;
        }
        List incomingTransitions = rtState.getIncomings();
        List outgoingTransitions = rtState.getOutgoings();
        if (!incomingTransitions.isEmpty() || !outgoingTransitions.isEmpty()) {
            CompositeTransactionalCommand composite = new CompositeTransactionalCommand(domain, "Refactor Transitions");
            Stream.concat(incomingTransitions.stream().map(in -> RerouteTransitionsToConnectionPointsCommand.rerouteTransition(domain, in, rtState, stateEditPart, UMLRTConnectionPointKind.ENTRY)), outgoingTransitions.stream().map(out -> RerouteTransitionsToConnectionPointsCommand.rerouteTransition(domain, out, rtState, stateEditPart, UMLRTConnectionPointKind.EXIT))).filter(Objects::nonNull).forEach(arg_0 -> ((CompositeTransactionalCommand)composite).compose(arg_0));
            result = composite.isEmpty() ? null : composite.reduce();
        }
        return result;
    }

    private static ICommand rerouteTransition(final TransactionalEditingDomain domain, final UMLRTTransition transition, final UMLRTState state, final IGraphicalEditPart stateEditPart, final UMLRTConnectionPointKind kind) {
        Point anchor;
        AbstractTransactionalCommand result = null;
        final ConnectionEditPart connection = RerouteTransitionsToConnectionPointsCommand.findConnection(transition, stateEditPart);
        if (connection != null && (anchor = RerouteTransitionsToConnectionPointsCommand.getAnchorPoint(connection, stateEditPart, kind == UMLRTConnectionPointKind.EXIT)) != null) {
            result = new AbstractTransactionalCommand(domain, "Refactor Transition", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    UMLRTConnectionPoint connectionPoint = RerouteTransitionsToConnectionPointsCommand.createConnectionPoint(domain, state, kind);
                    if (connectionPoint == null) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    Node connPtView = RerouteTransitionsToConnectionPointsCommand.createNode(domain, connectionPoint, stateEditPart, anchor);
                    Edge transitionView = (Edge)connection.getModel();
                    switch (kind) {
                        case ENTRY: {
                            transition.setTarget((UMLRTVertex)connectionPoint);
                            transitionView.setTarget((View)connPtView);
                            break;
                        }
                        default: {
                            transition.setSource((UMLRTVertex)connectionPoint);
                            transitionView.setSource((View)connPtView);
                        }
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
        }
        return result;
    }

    private static Point getAnchorPoint(ConnectionEditPart transition, IGraphicalEditPart state, boolean source) {
        Point result = null;
        IFigure figure = transition.getFigure();
        if (figure instanceof AbstractPointListShape) {
            result = source ? ((AbstractPointListShape)figure).getStart().getCopy() : ((AbstractPointListShape)figure).getEnd().getCopy();
            figure.translateToAbsolute((Translatable)result);
        }
        return result;
    }

    private static ConnectionEditPart findConnection(UMLRTTransition transition, IGraphicalEditPart stateEditPart) {
        Stream<IGraphicalEditPart> connections = Stream.concat(stateEditPart.getTargetConnections().stream(), stateEditPart.getSourceConnections().stream()).filter(ConnectionEditPart.class::isInstance).filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast);
        return connections.filter(ep -> ep.resolveSemanticElement() == transition.toUML()).findAny().map(ConnectionEditPart.class::cast).orElse(null);
    }

    private static UMLRTConnectionPoint createConnectionPoint(TransactionalEditingDomain domain, UMLRTState owner, UMLRTConnectionPointKind kind) throws ExecutionException {
        Pseudostate result = null;
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((Object)owner);
        IHintedType typeToCreate = kind == UMLRTConnectionPointKind.ENTRY ? UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_ENTRY_POINT : UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_EXIT_POINT;
        CreateElementRequest create = new CreateElementRequest(domain, (EObject)owner.toUML(), (IElementType)typeToCreate);
        create.setContainmentFeature(UMLPackage.Literals.STATE__CONNECTION_POINT);
        ICommand command = edit.getEditCommand((IEditCommandRequest)create);
        if (command != null && command.canExecute()) {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            result = (Pseudostate)command.getCommandResult().getReturnValue();
        }
        return result == null ? null : UMLRTConnectionPoint.getInstance(result);
    }

    private static Node createNode(TransactionalEditingDomain domain, UMLRTConnectionPoint connectionPoint, IGraphicalEditPart owner, Point location) {
        SemanticElementAdapter adapter = new SemanticElementAdapter((EObject)connectionPoint.toUML());
        PreferencesHint prefs = PreferencesHint.USE_DEFAULTS;
        if (owner.getRoot() instanceof IDiagramPreferenceSupport) {
            prefs = ((IDiagramPreferenceSupport)owner.getRoot()).getPreferencesHint();
        }
        String hint = connectionPoint.getKind() == UMLRTConnectionPointKind.ENTRY ? "Pseudostate_EntryPointShape" : "Pseudostate_ExitPointShape";
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)adapter, Node.class, hint, prefs);
        CreateViewRequest request = new CreateViewRequest(descriptor);
        request.setLocation(location);
        Command command = owner.getCommand((Request)request);
        if (command != null && command.canExecute()) {
            command.execute();
        }
        return (Node)descriptor.getAdapter(Node.class);
    }
}

