/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.function.Supplier;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.CustomizableDropEditPolicy;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.policies.CustomStateMachineDiagramDragDropEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTStateMachineDiagramUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPartTN;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies.RTCustomStateNavigationEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies.RTStateConnectionPointsCreationEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies.RTStateGraphicalNodeEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies.RTStateLayoutEditPolicy;

public class RTStateMachineEditPolicyProvider
extends AbstractProvider
implements IEditPolicyProvider {
    private static final ListMultimap<Class<? extends EditPart>, EditPolicyBinding> editPolicies = ImmutableListMultimap.builder().put(RTStateEditPart.class, (Object)RTStateMachineEditPolicyProvider.bind("CreationPolicy", RTStateConnectionPointsCreationEditPolicy::new)).put(RTStateEditPart.class, (Object)RTStateMachineEditPolicyProvider.bind("GraphicalNodeEditPolicy", RTStateGraphicalNodeEditPolicy::new)).put(RTStateEditPartTN.class, (Object)RTStateMachineEditPolicyProvider.bind("GraphicalNodeEditPolicy", RTStateGraphicalNodeEditPolicy::new)).put(RTStateEditPartTN.class, (Object)RTStateMachineEditPolicyProvider.bind("CreationPolicy", RTStateConnectionPointsCreationEditPolicy::new)).put(RTStateEditPart.class, (Object)RTStateMachineEditPolicyProvider.bind("NavigationEditPolicy", RTCustomStateNavigationEditPolicy::new)).put(RTStateEditPartTN.class, (Object)RTStateMachineEditPolicyProvider.bind("NavigationEditPolicy", RTCustomStateNavigationEditPolicy::new)).put(RTStateEditPartTN.class, (Object)RTStateMachineEditPolicyProvider.bind("LayoutEditPolicy", RTStateLayoutEditPolicy::new)).put(RTStateEditPart.class, (Object)RTStateMachineEditPolicyProvider.bind("LayoutEditPolicy", RTStateLayoutEditPolicy::new)).build();

    public boolean provides(IOperation operation) {
        CreateEditPoliciesOperation epOperation;
        boolean result;
        block4: {
            result = false;
            epOperation = (CreateEditPoliciesOperation)operation;
            try {
                ServicesRegistry registry = ServiceUtilsForEditPart.getInstance().getServiceRegistry(epOperation.getEditPart());
                if (registry != null) break block4;
                return false;
            }
            catch (ServiceException serviceException) {}
        }
        EditPart editPart = epOperation.getEditPart();
        if (UMLRTStateMachineDiagramUtils.isRTStateMachineDiagram((Diagram)RTStateMachineEditPolicyProvider.getDiagram(editPart))) {
            result = editPolicies.containsKey(editPart.getClass());
        }
        return result;
    }

    public void createEditPolicies(EditPart editPart) {
        editPolicies.get(editPart.getClass()).forEach(b -> b.apply(editPart));
    }

    private static EditPolicyBinding bind(String role, Supplier<? extends EditPolicy> editPolicy) {
        return new EditPolicyBinding(role, editPolicy);
    }

    private static Diagram getDiagram(EditPart editPart) {
        return (Diagram)TypeUtils.as((Object)editPart.getRoot().getContents().getModel(), Diagram.class);
    }

    private static final class EditPolicyBinding {
        final String role;
        final Supplier<? extends EditPolicy> editPolicySupplier;

        EditPolicyBinding(String role, Supplier<? extends EditPolicy> editPolicySupplier) {
            this.role = role;
            this.editPolicySupplier = editPolicySupplier;
        }

        void apply(EditPart editPart) {
            EditPolicy editPolicy = this.editPolicySupplier.get();
            if ("CreationPolicy".equals(this.role)) {
                editPart.installEditPolicy((Object)this.role, editPolicy);
                CustomStateMachineDiagramDragDropEditPolicy dragDropEditPolicy = new CustomStateMachineDiagramDragDropEditPolicy();
                editPart.installEditPolicy((Object)"DragDropPolicy", (EditPolicy)dragDropEditPolicy);
                CustomizableDropEditPolicy customEditPolicy = new CustomizableDropEditPolicy((EditPolicy)dragDropEditPolicy, editPolicy);
                editPart.installEditPolicy((Object)"DragDropPolicy", null);
                editPart.installEditPolicy((Object)"CreationPolicy", (EditPolicy)customEditPolicy);
            } else if ("DragDropPolicy".equals(this.role)) {
                EditPolicy creation = editPart.getEditPolicy((Object)"CreationPolicy");
                if (creation instanceof CustomizableDropEditPolicy) {
                    creation = ((CustomizableDropEditPolicy)creation).getDefaultCreationPolicy();
                }
                CustomizableDropEditPolicy customEditPolicy = new CustomizableDropEditPolicy(editPolicy, creation);
                editPart.installEditPolicy((Object)"DragDropPolicy", null);
                editPart.installEditPolicy((Object)"CreationPolicy", (EditPolicy)customEditPolicy);
            } else {
                editPart.installEditPolicy((Object)this.role, editPolicy);
            }
        }
    }
}

