/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.locator;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.NodeSnapHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrusrt.umlrt.core.utils.Either;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RelativePortLocation;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.BorderItemHelper;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTStateMachineDiagramUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPartTN;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTStateMachine;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.State;

public class StateBorderItemHelper<E extends Pseudostate>
extends BorderItemHelper<E> {
    public StateBorderItemHelper(Class<? extends E> semanticType, Supplier<? extends IGraphicalEditPart> hostSupplier, Supplier<? extends PortPositionLocator> positionLocatorSupplier) {
        super(semanticType, hostSupplier, positionLocatorSupplier);
    }

    protected ICommand basicGetSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor, Dimension size) {
        SetBoundsCommand setBoundsCommand = null;
        IGraphicalEditPart host = (IGraphicalEditPart)this.hostSupplier.get();
        IFigure hostFigure = host.getFigure();
        if (hostFigure.getBounds().isEmpty()) {
            return this.getDefferedSetBoundsCommand(host.getEditingDomain(), request, descriptor, size);
        }
        TransactionalEditingDomain editingDomain = host.getEditingDomain();
        Point parentLoc = hostFigure.getBounds().getLocation().getCopy();
        Point requestedLocation = this.computeLocation(request, descriptor, size);
        hostFigure.translateToRelative((Translatable)requestedLocation);
        PortPositionLocator locator = (PortPositionLocator)this.positionLocatorSupplier.get();
        if (locator == null) {
            return null;
        }
        Rectangle preferredBounds = locator.getPreferredLocation(new Rectangle(requestedLocation, size));
        Rectangle retainedBounds = preferredBounds.getCopy();
        Rectangle parentBounds = hostFigure.getBounds().getCopy();
        locator.setConstraint(preferredBounds.getCopy().translate(parentBounds.getLocation().getNegated()));
        int currentSide = locator.getCurrentSideOfParent();
        if (request.isSnapToEnabled() && currentSide != 17 && currentSide != 9 && currentSide != 20 && currentSide != 12) {
            Point wantedPoint = preferredBounds.getLocation();
            hostFigure.translateToAbsolute((Translatable)wantedPoint);
            Rectangle portBounds = new Rectangle(wantedPoint, size);
            NodeSnapHelper helper = new NodeSnapHelper((SnapToHelper)host.getAdapter(SnapToHelper.class), portBounds, false, false, true);
            ChangeBoundsRequest tmpRequest = new ChangeBoundsRequest((Object)"move");
            tmpRequest.setEditParts(Collections.emptyList());
            tmpRequest.setSnapToEnabled(true);
            tmpRequest.setLocation(portBounds.getLocation());
            helper.snapPoint(tmpRequest);
            preferredBounds.translate(tmpRequest.getMoveDelta());
            switch (currentSide) {
                case 1: 
                case 4: {
                    preferredBounds.y = retainedBounds.y;
                    break;
                }
                case 8: 
                case 16: {
                    preferredBounds.x = retainedBounds.x;
                    break;
                }
            }
        }
        Rectangle creationBounds = preferredBounds.getTranslated(parentLoc.getNegated());
        setBoundsCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)descriptor, creationBounds);
        return setBoundsCommand;
    }

    private ICommand getDefferedSetBoundsCommand(TransactionalEditingDomain domain, CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor, Dimension size) {
        return new DefferedSetBoundsCommand(domain, request, descriptor, size);
    }

    protected Point computeLocation(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor, Dimension size) {
        IGraphicalEditPart part;
        Optional refStateView;
        Point location = super.computeLocation(request, descriptor, size);
        if (this.getElement() != null && UMLRTEditPartUtils.isCanonicalRequest((CreateRequest)request) && (refStateView = (Optional)Either.cast((Object)(part = (IGraphicalEditPart)this.hostSupplier.get()), RTStateEditPart.class, RTStateEditPartTN.class).map(this::findStateViewAsTopState, this::findStateViewAsChildState).orElse(Optional.class, Optional.empty())).isPresent()) {
            Bounds refStateBounds = (Bounds)TypeUtils.as((Object)((Node)refStateView.get()).getLayoutConstraint(), Bounds.class);
            View refConnectionView = UMLRTEditPartUtils.findView((View)((View)refStateView.get()), (String)descriptor.getSemanticHint(), (EObject)this.getElement());
            if (refConnectionView == null) {
                return location;
            }
            Bounds refConnectionBounds = (Bounds)TypeUtils.as((Object)((Node)refConnectionView).getLayoutConstraint(), Bounds.class);
            Bounds hostBounds = (Bounds)TypeUtils.as((Object)((Node)part.getNotationView()).getLayoutConstraint(), Bounds.class);
            if (refConnectionBounds != null && refStateBounds != null && hostBounds != null) {
                Rectangle refState = new Rectangle(refStateBounds.getX(), refStateBounds.getY(), refStateBounds.getWidth(), refStateBounds.getHeight());
                Rectangle refConnection = new Rectangle(refConnectionBounds.getX(), refConnectionBounds.getY(), refConnectionBounds.getWidth(), refConnectionBounds.getHeight());
                Rectangle updatedState = new Rectangle(hostBounds.getX(), hostBounds.getY(), hostBounds.getWidth(), hostBounds.getHeight());
                RelativePortLocation loc = RelativePortLocation.of((Rectangle)refConnection, (Rectangle)refState);
                location = loc.applyTo(updatedState, size);
                location.translate(updatedState.getTopLeft());
                part.getFigure().translateToAbsolute((Translatable)location);
            }
        }
        return location;
    }

    protected Optional<View> findStateViewAsTopState(RTStateEditPart part) {
        return Optional.of((State)EditPartInheritanceUtils.resolveSemanticElement((EditPart)part, State.class)).map(UMLRTStateMachineDiagramUtils::getStateMachineDiagram).map(d -> ViewUtil.getChildBySemanticHint((View)d, (String)"State_Shape_TN"));
    }

    protected Optional<View> findStateViewAsChildState(RTStateEditPartTN part) {
        UMLRTState state = UMLRTState.getInstance((State)((State)EditPartInheritanceUtils.resolveSemanticElement((EditPart)part, State.class)));
        if (state == null) {
            return Optional.empty();
        }
        Diagram diagram = (Diagram)Either.of(Optional.ofNullable(state.getState()), Optional.ofNullable(state.getStateMachine())).map(UMLRTState::toUML, UMLRTStateMachine::toUML).map(UMLRTStateMachineDiagramUtils::getStateMachineDiagram, UMLRTStateMachineDiagramUtils::getStateMachineDiagram).getEither(Diagram.class);
        Optional<View> view = Optional.of(diagram).map(d -> UMLRTEditPartUtils.findView((View)d, (String)"State_Shape", (EObject)state.toUML()));
        return view;
    }

    protected class DefferedSetBoundsCommand
    extends SetBoundsCommand
    implements Runnable {
        private CreateViewRequest request;
        private CreateViewRequest.ViewDescriptor descriptor;
        private Dimension dimension;

        public DefferedSetBoundsCommand(TransactionalEditingDomain editingDomain, CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor, Dimension dimension) {
            super(editingDomain, "Deferred Command", (IAdaptable)descriptor, dimension);
            this.request = request;
            this.descriptor = descriptor;
            this.dimension = dimension;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            DiagramHelper.asyncExec((EditPart)((EditPart)StateBorderItemHelper.this.hostSupplier.get()), (Runnable)this);
            return CommandResult.newOKCommandResult();
        }

        @Override
        public void run() {
            EObject newE = (EObject)this.descriptor.getElementAdapter().getAdapter(EObject.class);
            if (newE instanceof Pseudostate) {
                StateBorderItemHelper.this.element = (Element)((Pseudostate)newE);
            }
            EditPart pseudoStateEP = ((IGraphicalEditPart)StateBorderItemHelper.this.hostSupplier.get()).findEditPart((EditPart)StateBorderItemHelper.this.hostSupplier.get(), newE);
            Point location = StateBorderItemHelper.this.computeLocation(this.request, this.descriptor, this.dimension);
            ((IGraphicalEditPart)StateBorderItemHelper.this.hostSupplier.get()).getFigure().translateToRelative((Translatable)location);
            location.translate(((IGraphicalEditPart)StateBorderItemHelper.this.hostSupplier.get()).getFigure().getBounds().getTopLeft().getNegated());
            SetBoundsCommand command = new SetBoundsCommand(this.getEditingDomain(), this.getLabel(), (IAdaptable)pseudoStateEP, location);
            if (command != null && command.canExecute()) {
                try {
                    command.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }
}

