/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.parsers;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class TransitionLabelParser
extends NamedElementLabelParser {
    public String getPrintString(IAdaptable element, int flags) {
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject instanceof NamedElement) {
            try {
                return ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)eObject)).getLabelProvider().getText((Object)eObject);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return super.getPrintString(element, flags);
    }

    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        List semantics = super.getSemanticElementsBeingParsed(element);
        if (!(element instanceof Transition)) {
            return semantics;
        }
        EContentsEList triggers = UMLRTExtensionUtil.getUMLRTContents((EObject)element, (EStructuralFeature)UMLPackage.Literals.TRANSITION__TRIGGER, (EStructuralFeature[])new EStructuralFeature[0]);
        if (!triggers.isEmpty()) {
            semantics.addAll(triggers);
            Set callEvents = triggers.stream().map(t -> t.getEvent()).filter(CallEvent.class::isInstance).map(CallEvent.class::cast).collect(Collectors.toSet());
            semantics.addAll(callEvents);
            semantics.addAll(callEvents.stream().map(ce -> ce.getOperation()).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        return semantics;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return true;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return super.areSemanticElementsAffected(listener, notification);
    }
}

