/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrusrt.umlrt.tooling.properties.providers.IRTTableSelectionProvider;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class RTNattableSelectionService
implements ISelectionChangedListener {
    private static RTNattableSelectionService instance;
    private Set<ISelectionListener> listeners = new HashSet<ISelectionListener>();
    private Set<IRTTableSelectionProvider> providers = new HashSet<IRTTableSelectionProvider>();
    private ISelection currentSelection;

    private RTNattableSelectionService() {
    }

    public static RTNattableSelectionService getInstance() {
        if (instance == null) {
            instance = new RTNattableSelectionService();
        }
        return instance;
    }

    public void addSelectionProvider(IRTTableSelectionProvider provider) {
        this.providers.add(provider);
        provider.addSelectionChangedListener(this);
    }

    public void removeSelectionProvider(IRTTableSelectionProvider provider) {
        provider.removeSelectionChangedListener(this);
        this.providers.remove(provider);
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IRTTableSelectionProvider provider = (IRTTableSelectionProvider)event.getSelectionProvider();
        INattableModelManager manager = provider.getTableManager();
        if (manager == null) {
            return;
        }
        ArrayList<Object> elements = new ArrayList<Object>(1);
        TableStructuredSelection selection = (TableStructuredSelection)event.getSelection();
        TableSelectionWrapper wrapper = (TableSelectionWrapper)selection.getAdapter(TableSelectionWrapper.class);
        Collection selectedCells = wrapper.getSelectedCells();
        int rowPosition = 0;
        for (PositionCoordinate coordinate : selectedCells) {
            rowPosition = coordinate.getRowPosition();
            RowHideShowLayer rowHideShowLayer = manager.getBodyLayerStack().getRowHideShowLayer();
            int realRowIndex = rowHideShowLayer.getRowIndexByPosition(rowPosition);
            Object rowElement = AxisUtils.getRepresentedElement((Object)manager.getRowElement(realRowIndex));
            if (elements.contains(rowElement)) continue;
            elements.add(rowElement);
        }
        this.currentSelection = new StructuredSelection(elements);
        IWorkbenchPart part = null;
        try {
            part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        }
        catch (Exception exception) {}
        if (part != null && "org.eclipse.ui.views.PropertySheet".equals(part.getSite().getId())) {
            for (ISelectionListener l : this.listeners) {
                l.selectionChanged(part, this.currentSelection);
            }
        }
    }
}

