/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.DecoratingObservableList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.IFilteredObservableList;

public class FilteredObservableList<E>
extends DecoratingObservableList<E>
implements IFilteredObservableList<E> {
    private final List<Predicate<? super E>> filters = new ArrayList<Predicate<? super E>>(3);
    private Predicate<? super E> filter;

    public FilteredObservableList(IObservableList<E> wrappedList) {
        super(wrappedList, true);
    }

    @Override
    public boolean addFilter(Predicate<? super E> filter) {
        boolean result;
        boolean bl = result = !this.filters.contains(filter) && this.filters.add(filter);
        if (result) {
            ArrayList oldView = new ArrayList(this);
            this.filter = (Predicate)this.filters.stream().reduce(Predicate::and).get();
            ArrayList newView = new ArrayList(this);
            ListDiff diff = Diffs.computeListDiff(oldView, newView);
            if (!diff.isEmpty()) {
                this.fireListChange(diff);
            }
        }
        return result;
    }

    @Override
    public boolean removeFilter(Predicate<? super E> filter) {
        boolean result = this.filters.remove(filter);
        if (result) {
            ArrayList oldView = new ArrayList(this);
            this.filters.remove(filter);
            this.filter = this.filters.stream().reduce(Predicate::and).orElse(null);
            ArrayList newView = new ArrayList(this);
            this.fireListChange(Diffs.computeListDiff(oldView, newView));
        }
        return result;
    }

    Stream<E> filtered() {
        this.getterCalled();
        return ((Stream)((IObservableList)this.getDecorated()).stream().sequential()).filter(this.filter);
    }

    public int size() {
        if (this.filter == null) {
            return super.size();
        }
        return (int)this.filtered().count();
    }

    public boolean contains(Object o) {
        if (this.filter == null) {
            return super.contains(o);
        }
        return o != null && this.filtered().anyMatch(o::equals);
    }

    public boolean containsAll(Collection<?> c) {
        if (this.filter == null) {
            return super.containsAll(c);
        }
        return this.filtered().filter(c::contains).count() >= (long)c.size();
    }

    public Iterator<E> iterator() {
        if (this.filter == null) {
            return super.iterator();
        }
        final Iterator delegate = super.iterator();
        return new Iterator<E>(){
            private E preparedNext;

            @Override
            public boolean hasNext() {
                while (this.preparedNext == null && delegate.hasNext()) {
                    Object next = delegate.next();
                    if (!FilteredObservableList.this.filter.test(next)) continue;
                    this.preparedNext = next;
                }
                return this.preparedNext != null;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.preparedNext;
                this.preparedNext = null;
                return result;
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public ListIterator<E> listIterator(int index) {
        if (this.filter == null) {
            return super.listIterator(index);
        }
        final ListIterator delegate = super.listIterator(index);
        return new ListIterator<E>(index){
            private E preparedNext;
            private E preparedPrev;
            private int cursor;
            {
                this.cursor = n;
            }

            @Override
            public boolean hasNext() {
                while (this.preparedNext == null && delegate.hasNext()) {
                    Object next = delegate.next();
                    if (!FilteredObservableList.this.filter.test(next)) continue;
                    this.preparedNext = next;
                }
                return this.preparedNext != null;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.preparedNext;
                this.preparedNext = null;
                this.preparedPrev = null;
                ++this.cursor;
                return result;
            }

            @Override
            public boolean hasPrevious() {
                while (this.preparedPrev == null && delegate.hasPrevious()) {
                    Object prev = delegate.previous();
                    if (!FilteredObservableList.this.filter.test(prev)) continue;
                    this.preparedPrev = prev;
                }
                return this.preparedPrev != null;
            }

            @Override
            public E previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                Object result = this.preparedPrev;
                this.preparedPrev = null;
                this.preparedNext = null;
                --this.cursor;
                return result;
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                delegate.remove();
            }

            @Override
            public void set(E e) {
                delegate.set(e);
            }

            @Override
            public void add(E e) {
                delegate.add(e);
            }
        };
    }

    public int hashCode() {
        if (this.filter == null) {
            return super.hashCode();
        }
        return this.filtered().mapToInt(Objects::hashCode).reduce(1, (a, b) -> 31 * a + b);
    }

    public boolean equals(Object obj) {
        if (this.filter == null) {
            return super.equals(obj);
        }
        return obj == this ? true : this.filtered().collect(Collectors.toList()).equals(obj);
    }

    public Object[] toArray() {
        if (this.filter == null) {
            return super.toArray();
        }
        return this.filtered().toArray(Object[]::new);
    }

    public <T> T[] toArray(T[] a) {
        if (this.filter == null) {
            return super.toArray((Object[])a);
        }
        return this.filtered().toArray(length -> (Object[])Array.newInstance(a.getClass().getComponentType(), length));
    }

    public String toString() {
        if (this.filter == null) {
            return super.toString();
        }
        return this.filtered().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    public static class Observing<E>
    extends FilteredObservableList<E>
    implements IObserving {
        private final IObserving observing;

        public Observing(IObservableList<E> wrappedList) {
            super(wrappedList);
            if (!(wrappedList instanceof IObserving)) {
                throw new IllegalArgumentException("not an observing list");
            }
            this.observing = (IObserving)wrappedList;
        }

        public Object getObserved() {
            return this.observing.getObserved();
        }
    }
}

