/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.editors;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrusrt.umlrt.core.commands.ExclusionCommand;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.IFilteredObservableList;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.Element;

public class InheritableMultipleReferenceEditor
extends MultipleReferenceEditor {
    private static final String SHOW_EXCLUDED_SETTING = "showExcluded";
    private String dialogSettingsKey;
    private Button toggleExcluded;
    private Button reinherit;
    private Predicate<Object> inheritanceFilter;
    private ISelectionChangedListener upDownEnablementListener;

    public InheritableMultipleReferenceEditor(Composite parent, int style) {
        this(parent, style, false, false, null);
    }

    public InheritableMultipleReferenceEditor(Composite parent, int style, String label) {
        this(parent, style, false, false, label);
    }

    public InheritableMultipleReferenceEditor(Composite parent, int style, boolean ordered, boolean unique, String label) {
        super(parent, style, ordered, unique, label);
        GridLayout layout = new GridLayout(7, false);
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.controlsSection.setLayout((Layout)layout);
        this.updateControls();
    }

    public final void setDialogSettingsKey(String key) {
        this.dialogSettingsKey = key;
        this.loadDialogSettings();
    }

    public final String getDialogSettingsKey() {
        return this.dialogSettingsKey;
    }

    protected final String getDialogSettingsKey(String subkey) {
        String result = this.getDialogSettingsKey();
        return result == null ? null : String.format("%s.%s", result, subkey);
    }

    protected Object getContextElement() {
        Object result = super.getContextElement();
        if (result instanceof UMLRTNamedElement) {
            result = ((UMLRTNamedElement)result).toUML();
        }
        return result;
    }

    protected void createListControls() {
        ImageDescriptor toggleInheritedImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)"$nl$/icons/full/etool16/show_excluded.png");
        this.toggleExcluded = this.createToggleButton(ExtendedImageRegistry.INSTANCE.getImage((Object)toggleInheritedImage), false, "Show excluded elements");
        super.createListControls();
        this.remove.setToolTipText("Remove or exclude selected element");
        ImageDescriptor reinheritImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)"$nl$/icons/full/etool16/reinherit.png");
        this.reinherit = this.createButton(ExtendedImageRegistry.INSTANCE.getImage((Object)reinheritImage), "Re-inherit selected element");
        this.loadDialogSettings();
    }

    protected Button createToggleButton(Image image, boolean selected, String tooltip) {
        Button result = new Button(this.controlsSection, 2);
        result.setImage(image);
        result.setSelection(selected);
        result.setToolTipText(tooltip);
        result.addSelectionListener((SelectionListener)this);
        return result;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.toggleExcluded) {
            this.toggleExcludedAction();
        } else if (e.widget == this.reinherit) {
            this.reinheritAction();
        } else {
            super.widgetSelected(e);
        }
    }

    protected void updateControls() {
        if (this.upDownEnablementListener != null) {
            this.treeViewer.removeSelectionChangedListener(this.upDownEnablementListener);
        }
        super.updateControls();
        if (this.controlsSection.getLayout() instanceof GridLayout) {
            this.setExclusion((Control)this.up, !this.ordered);
            this.setExclusion((Control)this.down, !this.ordered);
        }
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        if (this.ordered) {
            this.treeViewer.addSelectionChangedListener(this.getUpDownEnablementListener());
        }
        this.toggleExcluded.setEnabled(!this.readOnly && this.modelProperty instanceof IFilteredObservableList);
        this.reinherit.setEnabled(!this.readOnly);
    }

    private ISelectionChangedListener getUpDownEnablementListener() {
        if (this.upDownEnablementListener == null) {
            this.upDownEnablementListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    List elements = ((IStructuredSelection)event.getSelection()).toList();
                    boolean makesSense = InheritableMultipleReferenceEditor.this.ordered && !elements.isEmpty() && InheritableMultipleReferenceEditor.this.isHomogeneous(elements, UMLRTInheritanceKind::of);
                    InheritableMultipleReferenceEditor.this.up.setEnabled(makesSense && InheritableMultipleReferenceEditor.this.canMoveUp(elements));
                    InheritableMultipleReferenceEditor.this.down.setEnabled(makesSense && InheritableMultipleReferenceEditor.this.canMoveDown(elements));
                }
            };
        }
        return this.upDownEnablementListener;
    }

    protected final <E> boolean isHomogeneous(Collection<? extends E> elements, Function<? super E, ?> mapping) {
        return elements.stream().map(mapping).distinct().count() < 2L;
    }

    protected Predicate<Object> getInheritanceFilter(boolean demandCreate) {
        if (this.inheritanceFilter == null && demandCreate) {
            Predicate<Object> isExcluded = o -> {
                EObject eObject = EMFHelper.getEObject((Object)o);
                return eObject instanceof FacadeObject ? ((FacadeObject)eObject).isExcluded() : eObject instanceof Element && UMLRTExtensionUtil.isExcluded((Element)((Element)eObject));
            };
            this.inheritanceFilter = isExcluded.negate();
        }
        return this.inheritanceFilter;
    }

    protected void toggleExcludedAction() {
        this.updateShowExcluded();
        this.commit();
        this.storeDialogSettings();
    }

    private void updateShowExcluded() {
        boolean showExcluded = this.toggleExcluded.getSelection();
        if (this.modelProperty instanceof IFilteredObservableList) {
            IFilteredObservableList list = (IFilteredObservableList)this.modelProperty;
            Predicate<Object> filter = this.getInheritanceFilter(!showExcluded);
            boolean filterChanged = false;
            if (showExcluded) {
                if (filter != null) {
                    filterChanged = list.removeFilter(filter);
                }
            } else {
                filterChanged = list.addFilter(filter);
            }
            if (filterChanged && this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
                this.treeViewer.refresh();
            }
        }
    }

    protected void reinheritAction() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        List toReinherit = selection.toList().stream().filter(UMLRTNamedElement.class::isInstance).map(UMLRTNamedElement.class::cast).filter(UMLRTNamedElement::isInherited).map(UMLRTNamedElement::toUML).collect(Collectors.toList());
        if (!toReinherit.isEmpty()) {
            Element any = (Element)toReinherit.get(0);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)any);
            ICommand command = ExclusionCommand.getExclusionCommand((TransactionalEditingDomain)domain, toReinherit, (boolean)false);
            domain.getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)command));
        }
        this.commit();
    }

    public void setModelObservable(IObservableList modelProperty) {
        super.setModelObservable(modelProperty);
        this.loadDialogSettings();
    }

    public void handleChange(ChangeEvent event) {
        if (!this.isDisposed() && event.getObservable() == this.modelProperty) {
            this.updateShowExcluded();
        }
        super.handleChange(event);
    }

    protected void loadDialogSettings() {
        if (this.modelProperty == null) {
            return;
        }
        if (this.toggleExcluded != null) {
            boolean showExcluded = false;
            String setting = this.getDialogSettingsKey(SHOW_EXCLUDED_SETTING);
            if (setting != null) {
                showExcluded = this.getBoolean(setting, false);
                this.toggleExcluded.setSelection(showExcluded);
                this.updateShowExcluded();
            }
        }
    }

    protected void storeDialogSettings() {
        String setting;
        if (this.toggleExcluded != null && (setting = this.getDialogSettingsKey(SHOW_EXCLUDED_SETTING)) != null) {
            this.setBoolean(setting, this.toggleExcluded.getSelection());
        }
    }

    protected boolean getBoolean(String key, boolean defaultValue) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)"InheritableMultipleReferenceEditor");
        return section.get(key) == null ? defaultValue : section.getBoolean(key);
    }

    protected void setBoolean(String key, boolean value) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)"InheritableMultipleReferenceEditor");
        section.put(key, value);
    }

    protected boolean canMoveUp(Collection<? extends UMLRTNamedElement> selection) {
        boolean result = true;
        for (UMLRTNamedElement uMLRTNamedElement : selection) {
            UMLRTInheritanceKind before;
            int index = this.modelProperty.indexOf((Object)uMLRTNamedElement);
            UMLRTInheritanceKind kind = uMLRTNamedElement.getInheritanceKind();
            if (kind == UMLRTInheritanceKind.INHERITED) {
                result = false;
                break;
            }
            UMLRTInheritanceKind uMLRTInheritanceKind = before = index > 0 ? ((UMLRTNamedElement)this.modelProperty.get(index - 1)).getInheritanceKind() : null;
            if (before == kind) continue;
            result = false;
            break;
        }
        return result;
    }

    protected boolean canMoveDown(Collection<? extends UMLRTNamedElement> selection) {
        boolean result = true;
        int last = this.modelProperty.size() - 1;
        for (UMLRTNamedElement uMLRTNamedElement : selection) {
            UMLRTInheritanceKind after;
            int index = this.modelProperty.indexOf((Object)uMLRTNamedElement);
            UMLRTInheritanceKind kind = uMLRTNamedElement.getInheritanceKind();
            if (kind == UMLRTInheritanceKind.INHERITED) {
                result = false;
                break;
            }
            UMLRTInheritanceKind uMLRTInheritanceKind = after = index < last ? ((UMLRTNamedElement)this.modelProperty.get(index + 1)).getInheritanceKind() : null;
            if (after == kind) continue;
            result = false;
            break;
        }
        return result;
    }
}

