/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.advice;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;

public class ConnectorEndPortsCompatibilityAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeCreateRelationshipCommand(final CreateRelationshipRequest request) {
        return new AbstractTransactionalCommand(request.getEditingDomain(), "Check Connection", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                boolean result;
                Shell shell;
                if (request.getContainmentFeature() != UMLPackage.Literals.STRUCTURED_CLASSIFIER__OWNED_CONNECTOR) {
                    return CommandResult.newOKCommandResult();
                }
                if (!(request.getSource() instanceof Port) || !(request.getTarget() instanceof Port)) {
                    return CommandResult.newOKCommandResult();
                }
                boolean canConnect = true;
                Port port1 = (Port)request.getSource();
                Port port2 = (Port)request.getTarget();
                if (port1.getType() == null || !port1.getType().equals(port2.getType())) {
                    canConnect = false;
                }
                if (canConnect) {
                    canConnect = ConnectorEndPortsCompatibilityAdvice.this.checkConjugationCompatibility(request);
                }
                if (!canConnect && (shell = Display.getCurrent().getActiveShell()) != null && !(result = MessageDialog.openConfirm((Shell)shell, (String)"Incompatible Ports", (String)"The two ports are not compatible. Do you still want to create a connector?"))) {
                    return CommandResult.newCancelledCommandResult();
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private boolean checkConjugationCompatibility(CreateRelationshipRequest request) {
        boolean result = true;
        Port port1 = (Port)request.getSource();
        Port port2 = (Port)request.getTarget();
        View port1View = (View)request.getParameter("TARGET_GRAPHICAL_VIEW");
        View port2View = (View)request.getParameter("SOURCE_GRAPHICAL_VIEW");
        if (port2View != null && port2View.eContainer() != null && port1View != null && port1View.eContainer() != null) {
            boolean isDelegation;
            EObject port1Container = ((View)port2View.eContainer()).getElement();
            EObject port2Container = ((View)port1View.eContainer()).getElement();
            RTPortKindEnum port1Kind = RTPortUtils.getKind((Port)port1);
            RTPortKindEnum port2Kind = RTPortUtils.getKind((Port)port2);
            boolean bl = isDelegation = ElementTypeUtils.matches((EObject)port1Container, (String)"org.eclipse.papyrusrt.umlrt.core.Capsule") != false && port1.isService() || ElementTypeUtils.matches((EObject)port2Container, (String)"org.eclipse.papyrusrt.umlrt.core.Capsule") != false && port2.isService();
            if (!isDelegation) {
                if (port1.isConjugated() == port2.isConjugated()) {
                    result = false;
                }
            } else if (port1Container == port2Container && port1Kind == RTPortKindEnum.RELAY && port2Kind == RTPortKindEnum.RELAY) {
                if (port1.isConjugated() == port2.isConjugated()) {
                    result = false;
                }
            } else if (port1.isConjugated() != port2.isConjugated()) {
                result = false;
            }
        }
        return result;
    }
}

