/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.handlers;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrusrt.umlrt.core.commands.ExclusionCommand;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.uml2.uml.Element;

public class ExclusionHandler
extends AbstractHandler
implements IElementUpdater {
    private final boolean doUpdate;

    public ExclusionHandler() {
        this(false);
    }

    public ExclusionHandler(boolean doUpdate) {
        this.doUpdate = doUpdate;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain domain;
        Object result = null;
        IStructuredSelection sel = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        List elements = sel.toList().stream().map(e -> (EObject)PlatformHelper.getAdapter((Object)e, EObject.class)).filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList());
        if (!elements.isEmpty() && (domain = TransactionUtil.getEditingDomain((EObject)((EObject)elements.get(0)))) != null) {
            boolean exclude = event.getCommand().getId().contains("exclude") || event.getCommand().getId().contains("delete");
            Command command = GMFtoEMFCommandWrapper.wrap((ICommand)ExclusionCommand.getExclusionCommand((TransactionalEditingDomain)domain, elements, (boolean)exclude));
            domain.getCommandStack().execute(command);
            result = command.getResult().isEmpty() ? null : command.getResult().iterator().next();
        }
        return result;
    }

    public void updateElement(UIElement element, Map parameters) {
        if (this.doUpdate) {
            element.setText("Exclude Element");
            element.setTooltip("Undefine the inherited element in the inheriting namespace");
        }
    }
}

