/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.handlers;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.handlers.ExclusionHandler;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.handlers.OverrideDeleteSourceProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.uml2.uml.Element;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WorkbenchSourceProviders {
    private WorkbenchSourceProviders() {
    }

    public static void asyncInstall() {
        Display.getDefault().asyncExec(() -> {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWindowListener windowListener = WorkbenchSourceProviders.createWindowListener();
            workbench.addWindowListener(windowListener);
            Stream.of(workbench.getWorkbenchWindows()).forEach(arg_0 -> ((IWindowListener)windowListener).windowOpened(arg_0));
        });
    }

    private static IWindowListener createWindowListener() {
        return new IWindowListener(){
            private Map<IWorkbenchWindow, IDisposable> activations = new HashMap<IWorkbenchWindow, IDisposable>();

            public void windowOpened(IWorkbenchWindow window) {
                if (!this.activations.containsKey(window)) {
                    this.activations.put(window, WorkbenchSourceProviders.activateSources(window));
                }
            }

            public void windowClosed(IWorkbenchWindow window) {
                IDisposable activation = this.activations.remove(window);
                if (activation != null) {
                    activation.dispose();
                }
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowActivated(IWorkbenchWindow window) {
            }
        };
    }

    private static IDisposable activateSources(IWorkbenchWindow window) {
        ArrayList<IDisposable> tokens = new ArrayList<IDisposable>(3);
        ISelectionService selections = (ISelectionService)window.getService(ISelectionService.class);
        final ICommandService commands = (ICommandService)window.getService(ICommandService.class);
        IHandlerService handlers = (IHandlerService)window.getService(IHandlerService.class);
        final Command delete = commands.getCommand(ActionFactory.DELETE.getCommandId());
        if (delete != null) {
            Expression activeWhen;
            ExclusionHandler exclusionHandler = new ExclusionHandler(true);
            try {
                Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader("<and><with variable=\"papyrusrt.override.delete\">   <equals value=\"true\"/></with><with variable=\"activeMenuSelection\">   <iterate ifEmpty=\"true\" operation=\"or\">      <instanceof value=\"java.lang.Object\"/>   </iterate></with></and>")));
                activeWhen = ExpressionConverter.getDefault().perform(xml.getDocumentElement());
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
            IHandlerActivation excludeActivation = handlers.activateHandler(delete.getId(), (IHandler)exclusionHandler, activeWhen);
            selections.addSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    boolean activate;
                    Predicate<Element> excludeable = UMLRTProfileUtils::canExclude;
                    StructuredSelection ssel = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
                    boolean bl = activate = !ssel.isEmpty() && ssel.toList().stream().map(EMFHelper::getEObject).filter(Objects::nonNull).filter(Element.class::isInstance).map(Element.class::cast).filter(excludeable).count() == (long)ssel.size();
                    if (OverrideDeleteSourceProvider.setEnabled(activate, selection)) {
                        commands.refreshElements(delete.getId(), null);
                    }
                }
            });
            tokens.add(() -> handlers.deactivateHandler(excludeActivation));
        }
        return () -> tokens.forEach(IDisposable::dispose);
    }
}

