/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.providers;

import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ParameterTypeContentProvider
extends EncapsulatedContentProvider {
    public ParameterTypeContentProvider(IStaticContentProvider provider) {
        super((IStructuredContentProvider)provider);
    }

    public boolean isValidValue(Object element) {
        boolean result = super.isValidValue(element);
        if (result) {
            EObject eObject = EMFHelper.getEObject((Object)element);
            result = eObject instanceof Classifier && ParameterTypeContentProvider.isValidMessageParameterType((Classifier)eObject);
        }
        return result;
    }

    public Object[] getElements() {
        return Stream.of(super.getElements()).filter(this::isNavigable).toArray();
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        return Stream.of(super.getChildren(parentElement)).filter(this::isNavigable).toArray();
    }

    private boolean isNavigable(Object object) {
        EObject element = EMFHelper.getEObject((Object)object);
        return element != null && (Boolean)NavigableElementSwitch.NAVIGABLE_ELEMENT.doSwitch(element) != false;
    }

    public static boolean isValidMessageParameterType(Classifier classifier) {
        return (Boolean)ValidMessageParameterSwitch.VALID_PARAMETER_TYPE.doSwitch((EObject)classifier);
    }

    private static class NavigableElementSwitch
    extends ValidMessageParameterSwitch {
        static final NavigableElementSwitch NAVIGABLE_ELEMENT = new NavigableElementSwitch();

        private NavigableElementSwitch() {
        }

        public Boolean casePackage(Package object) {
            return true;
        }

        public Boolean casePackageImport(PackageImport object) {
            return true;
        }

        public Boolean caseElementImport(ElementImport object) {
            return true;
        }
    }

    private static class ValidMessageParameterSwitch
    extends UMLSwitch<Boolean> {
        static final ValidMessageParameterSwitch VALID_PARAMETER_TYPE = new ValidMessageParameterSwitch();

        private ValidMessageParameterSwitch() {
        }

        public Boolean defaultCase(EObject object) {
            return false;
        }

        public Boolean caseClassifier(Classifier object) {
            return false;
        }

        public Boolean caseClass(Class object) {
            if (object.eClass() == UMLPackage.Literals.CLASS && !CapsuleUtils.isCapsule((Classifier)object)) {
                return true;
            }
            return false;
        }

        public Boolean caseEnumeration(Enumeration object) {
            return true;
        }

        public Boolean casePrimitiveType(PrimitiveType object) {
            return true;
        }
    }
}

