/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ConstantContentProvider
extends UMLContentProvider {
    public Object[] getChildren(Object parentElement) {
        return Stream.of(super.getChildren(parentElement)).filter(this::isNavigable).toArray();
    }

    public boolean isValidValue(Object object) {
        EObject element = EMFHelper.getEObject((Object)object);
        if (!(element instanceof Property)) {
            return false;
        }
        if (CapsulePartUtils.isCapsulePart((Property)((Property)element)) || RTPortUtils.isRTPort((EObject)element)) {
            return false;
        }
        return ((Property)element).eIsSet((EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue());
    }

    private boolean isNavigable(Object object) {
        EObject element = EMFHelper.getEObject((Object)object);
        return element != null && (Boolean)NavigableElementSwitch.NAVIGABLE_ELEMENT.doSwitch(element) != false;
    }

    private static class NavigableElementSwitch
    extends UMLSwitch<Boolean> {
        static final NavigableElementSwitch NAVIGABLE_ELEMENT = new NavigableElementSwitch();

        private NavigableElementSwitch() {
        }

        public Boolean defaultCase(EObject object) {
            return false;
        }

        public Boolean caseProperty(Property object) {
            return true;
        }

        public Boolean casePackage(Package object) {
            return true;
        }

        public Boolean caseClassifier(Classifier object) {
            return true;
        }

        public Boolean casePackageImport(PackageImport object) {
            return true;
        }

        public Boolean caseElementImport(ElementImport object) {
            return true;
        }
    }
}

